/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl;

import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.XtmAction;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.services.translation.XtmCanceller;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.soap.api.ActionFactory;
import com.xtm.aem.soap.legacy.ObtainProjectStatusSoapAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectStatusUpdater {
    private static final Logger log = LoggerFactory.getLogger(ProjectStatusUpdater.class);
    private final TranslationCloudConfig cloudConfiguration;
    private final ActionFactory actionFactory;
    private final XtmCanceller canceller;

    public ProjectStatusUpdater(TranslationCloudConfig cloudConfiguration, ActionFactory actionFactory, XtmCanceller canceller) {
        this.cloudConfiguration = cloudConfiguration;
        this.actionFactory = actionFactory;
        this.canceller = canceller;
    }

    public TranslationConstants.TranslationStatus updateProjectStatus(TranslationConstants.TranslationStatus translationStatus, AemTranslationJob aemTranslationJob) throws TranslationException {
        switch (translationStatus) {
            case COMMITTED_FOR_TRANSLATION: {
                return this.startProject(aemTranslationJob);
            }
            case CANCEL: {
                return this.cancelProject(aemTranslationJob);
            }
            case SCOPE_REQUESTED: {
                return this.changeStatus(aemTranslationJob, TranslationConstants.TranslationStatus.SCOPE_COMPLETED);
            }
            case SUBMITTED: {
                return translationStatus;
            }
        }
        return this.getCurrentStatus(aemTranslationJob);
    }

    private TranslationConstants.TranslationStatus startProject(AemTranslationJob aemTranslationJob) throws TranslationException {
        log.info("Starting project with internal id '{}' in XTM with id '{}'", (Object)aemTranslationJob.getAemJobId(), (Object)aemTranslationJob.getXtmProjectId());
        XtmAction<Boolean> startProjectAction = this.actionFactory.getStartProjectAction(aemTranslationJob.getXtmProjectId(), this.cloudConfiguration);
        return startProjectAction.run() != false ? TranslationConstants.TranslationStatus.COMMITTED_FOR_TRANSLATION : TranslationConstants.TranslationStatus.UNKNOWN_STATE;
    }

    private TranslationConstants.TranslationStatus cancelProject(AemTranslationJob aemTranslationJob) throws TranslationException {
        this.canceller.cancel(aemTranslationJob);
        return TranslationConstants.TranslationStatus.CANCEL;
    }

    private TranslationConstants.TranslationStatus changeStatus(AemTranslationJob aemTranslationJob, TranslationConstants.TranslationStatus status) {
        log.info("Changing project status project with internal id '{}' in XTM with id '{}' to '{}'", new Object[]{aemTranslationJob.getAemJobId(), aemTranslationJob.getXtmProjectId(), status});
        return status;
    }

    private TranslationConstants.TranslationStatus getCurrentStatus(AemTranslationJob aemTranslationJob) throws TranslationException {
        log.info("Obtaining project status project with internal id {} in XTM with id {}", (Object)aemTranslationJob.getAemJobId(), (Object)aemTranslationJob.getXtmProjectId());
        ObtainProjectStatusSoapAction action = new ObtainProjectStatusSoapAction(aemTranslationJob.getXtmProjectId(), this.cloudConfiguration);
        TranslationConstants.TranslationStatus currentStatus = (TranslationConstants.TranslationStatus)action.runWithHandlers();
        log.info("Changing project status project with internal id {} in XTM with id {} with status {}", new Object[]{aemTranslationJob.getAemJobId(), aemTranslationJob.getXtmProjectId(), currentStatus});
        return currentStatus;
    }
}

