/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl;

import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestActionFactory;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.api.xtm.AemTranslationProject;
import com.xtm.aem.soap.legacy.CheckProjectCompletionSoapAction;
import com.xtm.aem.soap.legacy.ObtainJobStatusSoapAction;
import com.xtm.aem.soap.legacy.RetrieveTranslationResultAsInputStreamSoapAction;
import com.xtm.aem.soap.legacy.UpdateProjectActivitySoapAction;
import com.xtm.aem.soap.wsdl.LanguageCODE;
import com.xtm.aem.soap.wsdl.ProjectActivityStatusEnum;
import com.xtm.aem.soap.wsdl.XtmCheckProjectCompletionResponseAPI;
import com.xtm.aem.soap.wsdl.XtmJobStatusResponseAPI;
import com.xtm.aem.soap.wsdl.XtmPROJECTFILESMATCH;
import com.xtm.aem.soap.wsdl.XtmUpdateProjectActivityResponseAPI;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TranslationController.class}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class TranslationController {
    @Reference
    private RestActionFactory restActionFactory;

    public static InputStream retrieveTranslationResult(AemTranslationObject ato) throws TranslationException, PersistenceException {
        RetrieveTranslationResultAsInputStreamSoapAction action = new RetrieveTranslationResultAsInputStreamSoapAction(ato.getXtmJobId(), ato.getFileName(), ato.getProject().getConfig(), TranslationController.getTargetLanguageCode(ato.getJob()).value());
        InputStream translationResult = (InputStream)action.runWithHandlers();
        ato.setTranslationResult(translationResult);
        return ato.getTranslationResult();
    }

    public static TranslationConstants.TranslationStatus obtainTranslationStatus(AemTranslationObject ato) throws TranslationException {
        ObtainJobStatusSoapAction action = new ObtainJobStatusSoapAction(Sets.newHashSet((Object[])new Long[]{ato.getXtmJobId()}), ato.getProject().getConfig());
        Map xtmStatuses = (Map)action.runWithHandlers();
        ato.setTranslationStatus((TranslationConstants.TranslationStatus)xtmStatuses.get(ato.getXtmJobId()));
        return ato.getTranslationStatus();
    }

    public static XtmPROJECTFILESMATCH getFileMatching(AemTranslationObject ato, Collection<String> availableFiles) {
        if (ato.getFileName().contains("[" + Integer.toString(ato.getJob().getTargetLanguage().hashCode(), 36) + "]")) {
            return XtmPROJECTFILESMATCH.NO_MATCH;
        }
        if (availableFiles.contains(ato.getFileName())) {
            return XtmPROJECTFILESMATCH.MATCH_NAMES;
        }
        return XtmPROJECTFILESMATCH.NO_MATCH;
    }

    public static LanguageCODE getTargetLanguageCode(AemTranslationJob job) {
        return LanguageCODE.fromValue(job.getProject().getConfig().getLanguageMapping().get(job.getTargetLanguage()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getActiveXtmProjectId(AemTranslationProject atp, LanguageCODE targetLanguage) throws TranslationException {
        Class<TranslationController> clazz = TranslationController.class;
        synchronized (TranslationController.class) {
            XtmUpdateProjectActivityResponseAPI updateResponse;
            ArrayList<Long> activeWithoutTargetLang = new ArrayList<Long>();
            ArrayList<Long> notActiveWithTargetLang = new ArrayList<Long>();
            ArrayList<Long> notActiveWithoutTargetLang = new ArrayList<Long>();
            for (Long xtmProjectId : atp.getXtmProjectIds()) {
                if (ArrayUtils.contains((Object[])atp.getFinishedXtmProjectIds(), (Object)xtmProjectId)) continue;
                CheckProjectCompletionSoapAction checkAction = new CheckProjectCompletionSoapAction(xtmProjectId, atp.getConfig());
                XtmCheckProjectCompletionResponseAPI checkResponse = (XtmCheckProjectCompletionResponseAPI)checkAction.runWithHandlers();
                boolean isActive = checkResponse.getProject().getActivity() == ProjectActivityStatusEnum.ACTIVE;
                boolean hasTargetLang = checkResponse.getProject().getJobs().stream().map(XtmJobStatusResponseAPI::getTargetLanguage).anyMatch(targetLanguage::equals);
                if (isActive) {
                    if (hasTargetLang) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return xtmProjectId;
                    }
                    activeWithoutTargetLang.add(xtmProjectId);
                    continue;
                }
                if (hasTargetLang) {
                    notActiveWithTargetLang.add(xtmProjectId);
                    continue;
                }
                notActiveWithoutTargetLang.add(xtmProjectId);
            }
            for (Long xtmProjectId : notActiveWithTargetLang) {
                UpdateProjectActivitySoapAction updateAction = new UpdateProjectActivitySoapAction(xtmProjectId, atp.getConfig());
                updateResponse = (XtmUpdateProjectActivityResponseAPI)updateAction.runWithHandlers();
                if (updateResponse.getProjects().get(0).isResult().booleanValue()) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return xtmProjectId;
                }
                atp.markXtmProjectAsFinished(xtmProjectId);
            }
            if (activeWithoutTargetLang.size() > 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return (Long)activeWithoutTargetLang.get(0);
            }
            for (Long xtmProjectId : notActiveWithoutTargetLang) {
                UpdateProjectActivitySoapAction updateAction = new UpdateProjectActivitySoapAction(xtmProjectId, atp.getConfig());
                updateResponse = (XtmUpdateProjectActivityResponseAPI)updateAction.runWithHandlers();
                if (updateResponse.getProjects().get(0).isResult().booleanValue()) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return xtmProjectId;
                }
                atp.markXtmProjectAsFinished(xtmProjectId);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public void ensureLanguageSet(AemTranslationProject atp, String language, Long xtmProjectId) throws TranslationException {
        if (atp.getTranslationJobs().stream().filter(atj -> xtmProjectId.equals(atj.getXtmProjectId())).filter(AemTranslationJob::isSentToXtm).map(AemTranslationJob::getTargetLanguage).noneMatch(language::equalsIgnoreCase)) {
            TranslationCloudConfig cloudConfig = atp.getConfig();
            ImmutableList targetLanguages = ImmutableList.of((Object)cloudConfig.getLanguageMapping().get(language));
            this.restActionFactory.getUpdateProjectTargetLanguageAction(xtmProjectId, (List<String>)targetLanguages, cloudConfig).run();
        }
    }

    public static XMLGregorianCalendar getXmlDueDate(Date dueDate) {
        if (dueDate != null) {
            try {
                GregorianCalendar c = new GregorianCalendar();
                c.setTime(dueDate);
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException("Could not transform date '" + dueDate + "'");
            }
        }
        return null;
    }
}

