/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl;

import com.adobe.granite.translation.api.TranslationConfig;
import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationMetadata;
import com.adobe.granite.translation.api.TranslationObject;
import com.adobe.granite.translation.api.TranslationScope;
import com.adobe.granite.translation.api.TranslationState;
import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.util.IoStreams;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.api.xtm.AemTranslationProject;
import com.xtm.aem.services.translation.AbstractUnsupportedMethodsTranslationService;
import com.xtm.aem.services.translation.LogUtils;
import com.xtm.aem.soap.legacy.ObtainJobStatusSoapAction;
import com.xtm.aem.soap.legacy.ObtainProjectScopeSoapAction;
import com.xtm.aem.soap.legacy.RejectJobSoapAction;
import com.xtm.translation.connector.xtmforaem.api.TranslationSupportServicesHolder;
import com.xtm.translation.connector.xtmforaem.core.impl.JobStatusUpdater;
import com.xtm.translation.connector.xtmforaem.core.impl.TranslationController;
import com.xtm.translation.connector.xtmforaem.core.impl.TranslationJobController;
import com.xtm.translation.connector.xtmforaem.core.models.ComplexAemTranslationProjectManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XtmTranslationService
extends AbstractUnsupportedMethodsTranslationService {
    private static final Logger log = LoggerFactory.getLogger(XtmTranslationService.class);
    private static final String ROOT_PATH = "/conf/global/settings/cloudconfigs/translation/xtm";
    private final TranslationCloudConfig xtmCloudConfig;
    private final TranslationSupportServicesHolder services;

    public XtmTranslationService(TranslationConfig translationConfig, TranslationCloudConfig cloudConfig, TranslationSupportServicesHolder services) {
        super(cloudConfig != null ? cloudConfig.getLanguageMapping() : Collections.emptyMap(), Collections.emptyMap(), "xtm-connector", "XTM Connector", "Translated by XTM", ROOT_PATH, TranslationConstants.TranslationMethod.HUMAN_TRANSLATION, translationConfig);
        this.xtmCloudConfig = cloudConfig;
        this.services = services;
    }

    public Map<String, String> supportedLanguages() {
        log.trace("supportedLanguages()");
        return Collections.unmodifiableMap(this.availableLanguageMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createTranslationJob(String name, String description, String sourceLanguage, String targetLanguage, Date dueDate, TranslationState state, TranslationMetadata jobMetadata) throws TranslationException {
        log.trace("createTranslationJob('{}', '{}', '{}', '{}', '{}', '{}', '{}')", new Object[]{name, description, sourceLanguage, targetLanguage, dueDate, LogUtils.toLogString(state), LogUtils.toLogString(jobMetadata)});
        String standardizedSourceLanguage = XtmTranslationService.standardizeLanguage(sourceLanguage);
        String standardizedTargetLanguage = XtmTranslationService.standardizeLanguage(targetLanguage);
        String uuid = UUID.randomUUID().toString();
        String aemJobId = name + "_" + standardizedSourceLanguage + "_" + standardizedTargetLanguage + "_" + uuid;
        String xtmProjectName = this.getXtmJobName(name, standardizedSourceLanguage, standardizedTargetLanguage);
        Class<XtmTranslationService> clazz = XtmTranslationService.class;
        synchronized (XtmTranslationService.class) {
            try (ResourceResolver resourceResolver = this.services.getResourceResolverProvider().getXtmResourceResolver();){
                TranslationJobController.add(resourceResolver, aemJobId, standardizedSourceLanguage, standardizedTargetLanguage, xtmProjectName, description, dueDate, state.getStatus());
                resourceResolver.commit();
            }
            catch (IOException | LoginException e) {
                throw new TranslationException("Could not create translation job", e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
            // ** MonitorExit[var13_13] (shouldn't be in output)
            return aemJobId;
        }
    }

    private String getXtmJobName(String aemProjectTitle, String sourceLanguage, String targetLanguage) {
        String[] titleParts = aemProjectTitle.split("\\[.*]_translationjob");
        String title = titleParts[0];
        return this.xtmCloudConfig.getProjectNameTemplate().replace("$AEM_TITLE", title).replace("$SOURCE_LANGUAGE", sourceLanguage).replace("$TARGET_LANGUAGE", targetLanguage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String uploadTranslationObject(String aemJobId, TranslationObject translationObject) throws TranslationException {
        log.trace("uploadTranslationObject('{}', '{}')", (Object)aemJobId, (Object)LogUtils.toLogString(translationObject));
        String translationObjectId = translationObject.getId();
        if (!StringUtils.isBlank((CharSequence)translationObjectId) || !translationObject.getTranslationJobMetadata().isObjectTranslationRequired()) return translationObjectId;
        Class<XtmTranslationService> clazz = XtmTranslationService.class;
        synchronized (XtmTranslationService.class) {
            try (ResourceResolver resourceResolver = this.services.getResourceResolverProvider().getXtmResourceResolver();){
                AemTranslationProject project = ComplexAemTranslationProjectManager.getOrAdd(resourceResolver, aemJobId, this.xtmCloudConfig);
                AemTranslationJob job = project.getTranslationJob(aemJobId);
                translationObjectId = this.services.getTranslationJobController().addAemTranslationObject(job, translationObject, this.xtmCloudConfig).getAemTranslationObjectId();
                if (!resourceResolver.hasChanges()) return translationObjectId;
                resourceResolver.commit();
            }
            catch (XtmConnectorException | IOException | LoginException e) {
                throw new TranslationException("Could not upload new translation object", e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return translationObjectId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranslationScope getFinalScope(String aemJobId) throws TranslationException {
        log.trace("getFinalScope('{}')", (Object)aemJobId);
        TranslationScope scope = null;
        Class<XtmTranslationService> clazz = XtmTranslationService.class;
        synchronized (XtmTranslationService.class) {
            try (ResourceResolver resourceResolver = this.services.getResourceResolverProvider().getXtmResourceResolver();){
                AemTranslationProject project = ComplexAemTranslationProjectManager.getOrAdd(resourceResolver, aemJobId, this.xtmCloudConfig);
                AemTranslationJob job = project.getTranslationJob(aemJobId);
                if (job != null) {
                    ObtainProjectScopeSoapAction action = new ObtainProjectScopeSoapAction(job.getXtmProjectId(), this.xtmCloudConfig);
                    scope = (TranslationScope)action.runWithHandlers();
                }
                if (resourceResolver.hasChanges()) {
                    resourceResolver.commit();
                }
            }
            catch (LoginException | PersistenceException e) {
                throw new TranslationException("Could not retrieve final scope", e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return scope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranslationConstants.TranslationStatus updateTranslationJobState(String aemJobId, TranslationState translationState) throws TranslationException {
        log.trace("updateTranslationJobState('{}', '{}')", (Object)aemJobId, (Object)LogUtils.toLogString(translationState));
        if (aemJobId == null || "dummy".equals(aemJobId)) {
            return translationState.getStatus();
        }
        Class<XtmTranslationService> clazz = XtmTranslationService.class;
        synchronized (XtmTranslationService.class) {
            TranslationConstants.TranslationStatus translationStatus = translationState.getStatus();
            try (ResourceResolver resourceResolver = this.services.getResourceResolverProvider().getXtmResourceResolver();){
                AemTranslationProject project = ComplexAemTranslationProjectManager.getOrAdd(resourceResolver, aemJobId, this.xtmCloudConfig);
                AemTranslationJob job = project.getTranslationJob(aemJobId);
                if (job != null) {
                    if (!job.isSentToXtm() && translationStatus == TranslationConstants.TranslationStatus.COMMITTED_FOR_TRANSLATION) {
                        this.services.getTranslationJobController().sendToXtm(job, resourceResolver);
                    }
                    translationStatus = this.services.getTranslationJobController().updateTranslationStatus(job, translationStatus);
                }
                if (resourceResolver.hasChanges()) {
                    resourceResolver.commit();
                }
            }
            catch (XtmConnectorException | IOException | LoginException e) {
                throw new TranslationException("Could not update translation job state", e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return translationStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranslationConstants.TranslationStatus getTranslationJobStatus(String aemJobId) throws TranslationException {
        log.trace("getTranslationJobStatus('{}')", (Object)aemJobId);
        Class<XtmTranslationService> clazz = XtmTranslationService.class;
        synchronized (XtmTranslationService.class) {
            TranslationConstants.TranslationStatus translationStatus = null;
            try (ResourceResolver resourceResolver = this.services.getResourceResolverProvider().getXtmResourceResolver();){
                AemTranslationProject project = ComplexAemTranslationProjectManager.getOrAdd(resourceResolver, aemJobId, this.xtmCloudConfig);
                AemTranslationJob job = project.getTranslationJob(aemJobId);
                if (job != null) {
                    if (!job.isSentToXtm() && job.getTranslationStatus().equals((Object)TranslationConstants.TranslationStatus.SCOPE_COMPLETED)) {
                        this.services.getTranslationJobController().sendToXtm(job, resourceResolver);
                    }
                    translationStatus = TranslationJobController.obtainTranslationStatus(job);
                }
                if (resourceResolver.hasChanges()) {
                    resourceResolver.commit();
                }
            }
            catch (XtmConnectorException | IOException | LoginException e) {
                throw new TranslationException("Could not retrieve translation job status", e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return translationStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getTranslatedObject(String aemJobId, TranslationObject translationObject) throws TranslationException {
        log.trace("getTranslatedObject('{}', '{}')", (Object)aemJobId, (Object)LogUtils.toLogString(translationObject));
        Class<XtmTranslationService> clazz = XtmTranslationService.class;
        synchronized (XtmTranslationService.class) {
            InputStream translatedObject;
            try (ResourceResolver resourceResolver = this.services.getResourceResolverProvider().getXtmResourceResolver();){
                AemTranslationProject project = ComplexAemTranslationProjectManager.getOrAdd(resourceResolver, aemJobId, this.xtmCloudConfig);
                AemTranslationJob job = project.getTranslationJob(aemJobId);
                AemTranslationObject ato = job.getAemTranslationObject(translationObject.getId());
                InputStream translationResult = ato.getTranslationResult();
                InputStream inputStream = translatedObject = translationResult != null ? IoStreams.prefetchToMemory(translationResult) : new ByteArrayInputStream(ato.getTranslationFile().getBytes());
                if (resourceResolver.hasChanges()) {
                    resourceResolver.commit();
                }
            }
            catch (IOException | LoginException e) {
                throw new TranslationException("Error obtaining file contents", e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return translatedObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranslationConstants.TranslationStatus updateTranslationObjectState(String aemJobId, TranslationObject translationObject, TranslationState translationState) throws TranslationException {
        log.trace("updateTranslationObjectState('{}', '{}', '{}')", new Object[]{aemJobId, LogUtils.toLogString(translationObject), translationState.getStatus()});
        if (aemJobId == null) {
            return translationState.getStatus();
        }
        TranslationConstants.TranslationStatus translationStatus = translationState.getStatus();
        if (translationObject.getTranslationJobMetadata().isObjectTranslationRequired()) {
            if (StringUtils.isBlank((CharSequence)translationObject.getId())) {
                log.debug("\n****\n**** Overriding TranslationStatus to READY_FOR_REVIEW \n****");
                translationStatus = TranslationConstants.TranslationStatus.READY_FOR_REVIEW;
            }
            Class<XtmTranslationService> clazz = XtmTranslationService.class;
            synchronized (XtmTranslationService.class) {
                try (ResourceResolver resourceResolver = this.services.getResourceResolverProvider().getXtmResourceResolver();){
                    AemTranslationProject project = ComplexAemTranslationProjectManager.getOrAdd(resourceResolver, aemJobId, this.xtmCloudConfig);
                    AemTranslationJob job = project.getTranslationJob(aemJobId);
                    if (job.isSentToXtm()) {
                        AemTranslationObject aemTranslationObject = job.getAemTranslationObject(translationObject.getId());
                        JobStatusUpdater jobStatusUpdater = new JobStatusUpdater(this.xtmCloudConfig, this.services.getCanceller());
                        translationStatus = jobStatusUpdater.updateTranslationStatus(translationStatus, aemTranslationObject);
                    }
                    if (resourceResolver.hasChanges()) {
                        resourceResolver.commit();
                    }
                }
                catch (LoginException | PersistenceException e) {
                    throw new TranslationException("Error updating translation object state", e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        translationStatus = translationObject.getTranslationJobMetadata().getTranslationState().getStatus();
        return translationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranslationConstants.TranslationStatus getTranslationObjectStatus(String aemJobId, TranslationObject translationObject) throws TranslationException {
        log.trace("getTranslationObjectStatus('{}', '{}')", (Object)aemJobId, (Object)LogUtils.toLogString(translationObject));
        if (aemJobId == null) {
            return translationObject.getTranslationJobMetadata().getTranslationState().getStatus();
        }
        if (StringUtils.isBlank((CharSequence)translationObject.getId())) {
            log.debug("\n****\n**** Overriding TranslationStatus to READY_FOR_REVIEW \n****");
            return TranslationConstants.TranslationStatus.READY_FOR_REVIEW;
        }
        if (translationObject.getTranslationJobMetadata().getTranslationState().getStatus().equals((Object)TranslationConstants.TranslationStatus.CANCEL)) {
            log.debug("\n****\n**** Overriding TranslationStatus to CANCEL \n****");
            return TranslationConstants.TranslationStatus.CANCEL;
        }
        Class<XtmTranslationService> clazz = XtmTranslationService.class;
        synchronized (XtmTranslationService.class) {
            TranslationConstants.TranslationStatus translationStatus;
            try (ResourceResolver resourceResolver = this.services.getResourceResolverProvider().getXtmResourceResolver();){
                AemTranslationProject project = ComplexAemTranslationProjectManager.getOrAdd(resourceResolver, aemJobId, this.xtmCloudConfig);
                AemTranslationJob job = project.getTranslationJob(aemJobId);
                AemTranslationObject ato = job.getAemTranslationObject(translationObject.getId());
                translationStatus = TranslationController.obtainTranslationStatus(ato);
                if (translationStatus == TranslationConstants.TranslationStatus.TRANSLATED) {
                    TranslationController.retrieveTranslationResult(ato);
                }
                if (resourceResolver.hasChanges()) {
                    resourceResolver.commit();
                }
            }
            catch (LoginException | PersistenceException e) {
                throw new TranslationException("Error updating translation object state", e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return translationStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranslationConstants.TranslationStatus[] updateTranslationObjectsState(String aemJobId, TranslationObject[] translationObjects, TranslationState[] translationStates) throws TranslationException {
        if (log.isTraceEnabled()) {
            log.trace("updateTranslationObjectsState('{}', '{}', '{}')", new Object[]{aemJobId, LogUtils.toLogString(translationObjects), LogUtils.toLogString(translationStates)});
        }
        TranslationConstants.TranslationStatus[] resultStates = (TranslationConstants.TranslationStatus[])Arrays.stream(translationObjects).map(TranslationObject::getTranslationJobMetadata).map(TranslationMetadata::getTranslationState).map(TranslationState::getStatus).toArray(TranslationConstants.TranslationStatus[]::new);
        if (aemJobId == null) {
            return resultStates;
        }
        ArrayList<String> statusJobIdList = new ArrayList<String>();
        ArrayList<String> cancelJobIdList = new ArrayList<String>();
        ArrayList<String> rejectJobIdList = new ArrayList<String>();
        HashMap<String, TranslationConstants.TranslationStatus> statusMap = new HashMap<String, TranslationConstants.TranslationStatus>();
        Class<XtmTranslationService> clazz = XtmTranslationService.class;
        synchronized (XtmTranslationService.class) {
            try (ResourceResolver resourceResolver = this.services.getResourceResolverProvider().getXtmResourceResolver();){
                AemTranslationProject project = ComplexAemTranslationProjectManager.getOrAdd(resourceResolver, aemJobId, this.xtmCloudConfig);
                AemTranslationJob job = project.getTranslationJob(aemJobId);
                for (int toIndex = 0; toIndex < translationObjects.length; ++toIndex) {
                    TranslationObject translationObject = translationObjects[toIndex];
                    String translationObjectId = translationObject.getId();
                    log.debug("XtmTranslationService.updateTranslationObjectsState [jobId: " + aemJobId + ", objectId: " + translationObjectId + ", currentState: " + translationObject.getTranslationJobMetadata().getTranslationState().getStatus() + ", updateState: " + translationStates[toIndex].getStatus() + "]");
                    if (translationObject.getTranslationJobMetadata().isObjectTranslationRequired()) {
                        if (StringUtils.isBlank((CharSequence)translationObjectId)) {
                            switch (translationStates[toIndex].getStatus()) {
                                case SCOPE_REQUESTED: {
                                    statusMap.put(translationObjectId, TranslationConstants.TranslationStatus.SCOPE_COMPLETED);
                                    break;
                                }
                                case COMMITTED_FOR_TRANSLATION: {
                                    statusMap.put(translationObjectId, TranslationConstants.TranslationStatus.READY_FOR_REVIEW);
                                    break;
                                }
                                case REJECTED: {
                                    statusMap.put(translationObjectId, TranslationConstants.TranslationStatus.COMMITTED_FOR_TRANSLATION);
                                    break;
                                }
                                default: {
                                    statusMap.put(translationObjectId, translationStates[toIndex].getStatus());
                                    break;
                                }
                            }
                            continue;
                        }
                        switch (translationStates[toIndex].getStatus()) {
                            case CANCEL: {
                                cancelJobIdList.add(translationObjectId);
                                break;
                            }
                            case REJECTED: {
                                rejectJobIdList.add(translationObjectId);
                                break;
                            }
                            default: {
                                statusJobIdList.add(translationObjectId);
                                break;
                            }
                        }
                        continue;
                    }
                    statusMap.put(translationObjectId, translationObject.getTranslationJobMetadata().getTranslationState().getStatus());
                }
                if (!cancelJobIdList.isEmpty()) {
                    List translationObjectsToCancel = cancelJobIdList.stream().map(job::getAemTranslationObject).filter(Objects::nonNull).collect(Collectors.toList());
                    for (AemTranslationObject toCancel : translationObjectsToCancel) {
                        this.services.getCanceller().cancel(toCancel);
                        statusMap.put(toCancel.getXtmJobId().toString(), TranslationConstants.TranslationStatus.CANCEL);
                    }
                }
                if (!rejectJobIdList.isEmpty()) {
                    List<Long> rejectJobIds = rejectJobIdList.stream().map(job::getAemTranslationObject).filter(Objects::nonNull).map(AemTranslationObject::getXtmJobId).collect(Collectors.toList());
                    RejectJobSoapAction rejectJobAction = new RejectJobSoapAction(rejectJobIds, this.xtmCloudConfig);
                    Map rejectedJobStates = (Map)rejectJobAction.runWithHandlers();
                    rejectJobIds.forEach(jobId -> {
                        if (rejectedJobStates.containsKey(jobId)) {
                            statusMap.put(jobId.toString(), (TranslationConstants.TranslationStatus)rejectedJobStates.get(jobId));
                        }
                    });
                }
                if (!statusJobIdList.isEmpty()) {
                    Map jobIdToInternalJobIds = statusJobIdList.stream().map(job::getAemTranslationObject).filter(Objects::nonNull).filter(ato -> ato.getXtmJobId() != null).filter(ato -> StringUtils.isNotBlank((CharSequence)ato.getAemTranslationObjectId())).collect(Collectors.groupingBy(AemTranslationObject::getXtmJobId, Collectors.mapping(AemTranslationObject::getAemTranslationObjectId, Collectors.toList())));
                    ObtainJobStatusSoapAction statusJobAction = new ObtainJobStatusSoapAction(jobIdToInternalJobIds.keySet(), this.xtmCloudConfig);
                    Map translationStatusMappedByJobId = (Map)statusJobAction.runWithHandlers();
                    for (Map.Entry translationStatusEntry : translationStatusMappedByJobId.entrySet()) {
                        jobIdToInternalJobIds.get(translationStatusEntry.getKey()).stream().filter(Objects::nonNull).forEach(id -> {
                            TranslationConstants.TranslationStatus cfr_ignored_0 = (TranslationConstants.TranslationStatus)statusMap.put((String)id, (TranslationConstants.TranslationStatus)translationStatusEntry.getValue());
                        });
                    }
                }
                if (resourceResolver.hasChanges()) {
                    resourceResolver.commit();
                }
            }
            catch (LoginException | PersistenceException e) {
                throw new TranslationException("Error updating translation object state", e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            for (int toIndex = 0; toIndex < translationObjects.length; ++toIndex) {
                TranslationConstants.TranslationStatus translationStatus = (TranslationConstants.TranslationStatus)statusMap.get(translationObjects[toIndex].getId());
                if (translationStatus == null) continue;
                resultStates[toIndex] = translationStatus;
            }
            return resultStates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranslationConstants.TranslationStatus[] getTranslationObjectsStatus(String aemJobId, TranslationObject[] translationObjects) throws TranslationException {
        if (log.isTraceEnabled()) {
            log.trace("getTranslationObjectsStatus('{}', '{}')", (Object)aemJobId, (Object)LogUtils.toLogString(translationObjects));
        }
        HashMap<String, TranslationConstants.TranslationStatus> statusMap = new HashMap<String, TranslationConstants.TranslationStatus>();
        TranslationConstants.TranslationStatus[] resultStates = (TranslationConstants.TranslationStatus[])Arrays.stream(translationObjects).map(TranslationObject::getTranslationJobMetadata).map(TranslationMetadata::getTranslationState).map(TranslationState::getStatus).toArray(TranslationConstants.TranslationStatus[]::new);
        if (aemJobId == null) {
            return resultStates;
        }
        Class<XtmTranslationService> clazz = XtmTranslationService.class;
        synchronized (XtmTranslationService.class) {
            try (ResourceResolver resourceResolver = this.services.getResourceResolverProvider().getXtmResourceResolver();){
                AemTranslationProject project = ComplexAemTranslationProjectManager.getOrAdd(resourceResolver, aemJobId, this.xtmCloudConfig);
                AemTranslationJob job = project.getTranslationJob(aemJobId);
                ArrayList<String> statusInternalJobIds = new ArrayList<String>();
                for (TranslationObject translationObject : translationObjects) {
                    TranslationMetadata translationJobMetadata = translationObject.getTranslationJobMetadata();
                    TranslationConstants.TranslationStatus translationStatus = translationJobMetadata.getTranslationState().getStatus();
                    String translationObjectId = translationObject.getId();
                    if (!translationJobMetadata.isObjectTranslationRequired() || !StringUtils.isNotBlank((CharSequence)translationObjectId)) continue;
                    if (translationStatus == TranslationConstants.TranslationStatus.CANCEL || translationStatus == TranslationConstants.TranslationStatus.APPROVED || translationStatus == TranslationConstants.TranslationStatus.COMPLETE || translationStatus == TranslationConstants.TranslationStatus.ARCHIVE) {
                        statusMap.put(translationObjectId, translationStatus);
                        continue;
                    }
                    statusInternalJobIds.add(translationObjectId);
                }
                if (!statusInternalJobIds.isEmpty()) {
                    Map jobIdToInternalJobIds = statusInternalJobIds.stream().map(job::getAemTranslationObject).filter(Objects::nonNull).filter(ato -> ato.getXtmJobId() != null).filter(ato -> StringUtils.isNotBlank((CharSequence)ato.getAemTranslationObjectId())).collect(Collectors.groupingBy(AemTranslationObject::getXtmJobId, Collectors.mapping(AemTranslationObject::getAemTranslationObjectId, Collectors.toList())));
                    ObtainJobStatusSoapAction statusJobAction = new ObtainJobStatusSoapAction(jobIdToInternalJobIds.keySet(), this.xtmCloudConfig);
                    Map jobIdToTranslationStatus = (Map)statusJobAction.runWithHandlers();
                    for (Map.Entry mapEntry : jobIdToTranslationStatus.entrySet()) {
                        jobIdToInternalJobIds.get(mapEntry.getKey()).stream().filter(Objects::nonNull).forEach(id -> {
                            TranslationConstants.TranslationStatus cfr_ignored_0 = (TranslationConstants.TranslationStatus)statusMap.put((String)id, (TranslationConstants.TranslationStatus)mapEntry.getValue());
                        });
                    }
                }
                for (int toIndex = 0; toIndex < translationObjects.length; ++toIndex) {
                    TranslationConstants.TranslationStatus newStatus = statusMap.getOrDefault(translationObjects[toIndex].getId(), TranslationConstants.TranslationStatus.READY_FOR_REVIEW);
                    if (newStatus == TranslationConstants.TranslationStatus.TRANSLATED && resultStates[toIndex] != TranslationConstants.TranslationStatus.TRANSLATED) {
                        try {
                            TranslationController.retrieveTranslationResult(job.getAemTranslationObject(translationObjects[toIndex].getId()));
                            resultStates[toIndex] = newStatus;
                        }
                        catch (TranslationException e) {
                            log.warn("Could not fetch translated file for object '{}' from project '{}'", new Object[]{translationObjects[toIndex].getId(), project.getRawProject().getPath(), e});
                        }
                        continue;
                    }
                    resultStates[toIndex] = newStatus;
                }
                if (resourceResolver.hasChanges()) {
                    resourceResolver.commit();
                }
            }
            catch (LoginException | PersistenceException e) {
                throw new TranslationException("Error updating translation object state", e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return resultStates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDueDate(String aemJobId, Date date) throws TranslationException {
        log.trace("updateDueDate('{}', '{}')", (Object)aemJobId, (Object)date);
        Class<XtmTranslationService> clazz = XtmTranslationService.class;
        synchronized (XtmTranslationService.class) {
            try (ResourceResolver resourceResolver = this.services.getResourceResolverProvider().getXtmResourceResolver();){
                AemTranslationProject project = ComplexAemTranslationProjectManager.getOrAdd(resourceResolver, aemJobId, this.xtmCloudConfig);
                AemTranslationJob job = Objects.requireNonNull(project).getTranslationJob(aemJobId);
                TranslationJobController.updateDueDate(job, date);
                if (resourceResolver.hasChanges()) {
                    resourceResolver.commit();
                }
            }
            catch (LoginException | PersistenceException e) {
                throw new TranslationException("Error obtaining file contents", e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public boolean isDirectionSupported(String sourceLanguage, String targetLanguage) {
        return this.availableLanguageMap.containsKey(XtmTranslationService.standardizeLanguage(sourceLanguage)) && this.availableLanguageMap.containsKey(XtmTranslationService.standardizeLanguage(targetLanguage));
    }

    private static String standardizeLanguage(String language) {
        return language.toLowerCase().replace('-', '_');
    }
}

