/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl.servlets;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.xtm.translation.connector.xtmforaem.core.impl.servlets.XtmDropdownDataProviderService;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.vendor=XTM Intl", "sling.servlet.methods=GET", "sling.servlet.methods=POST", "sling.servlet.paths=/services/xtm"})
public class XtmConnectorServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(XtmConnectorServlet.class);
    private static final Pattern DIGITS_ONLY = Pattern.compile("\\d+");
    private final Gson gson = new Gson();
    @Reference
    private XtmDropdownDataProviderService xtmDropdownDataProviderService;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        log.trace("GET SERVLET");
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        String selectorString = request.getRequestPathInfo().getSelectorString();
        if ("customerList".equals(selectorString)) {
            Map<String, String> customers;
            if (this.xtmDropdownDataProviderService.getXtmCloudConfig() == null) {
                String userid = StringUtils.trimToEmpty((String)request.getParameter("userid"));
                this.xtmDropdownDataProviderService.init(request.getParameter("endpoint"), request.getParameter("client"), Long.parseLong(userid), request.getParameter("pwd"));
                this.xtmDropdownDataProviderService.canConnect();
            }
            if ((customers = this.xtmDropdownDataProviderService.getAvailableTranslationCustomers()) == null) {
                response.setStatus(400);
                response.getWriter().write("Failed to obtain customers - check credentials.");
            } else {
                this.writeAsJsonArray(response.getWriter(), "customers", customers);
            }
        } else if ("workflowList".equals(selectorString)) {
            String customerId = Objects.requireNonNull(request.getRequestParameter("custid")).getString();
            Map<String, String> workflows = this.xtmDropdownDataProviderService.getAvailableTranslationWorkflows(Long.parseLong(customerId));
            if (workflows == null) {
                response.setStatus(400);
                response.getWriter().write("Failed to obtain workflows - check credentials.");
            } else {
                this.writeAsJsonArray(response.getWriter(), "workflows", workflows);
            }
        } else {
            response.setStatus(400);
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        block5: {
            log.trace("POST SERVLET");
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            JsonWriter jw = this.gson.newJsonWriter((Writer)response.getWriter());
            String userid = StringUtils.trimToEmpty((String)request.getParameter("userid"));
            if (DIGITS_ONLY.matcher(userid).matches()) {
                this.xtmDropdownDataProviderService.init(request.getParameter("endpoint"), request.getParameter("client"), Long.parseLong(userid), request.getParameter("pwd"));
                try {
                    String errorMessage = this.xtmDropdownDataProviderService.canConnect();
                    this.setVerificationStatus(jw, errorMessage);
                    if (StringUtils.isBlank((CharSequence)errorMessage)) {
                        log.debug("Connection parameters correct");
                        break block5;
                    }
                    log.debug("Connection parameters incorrect");
                }
                catch (IOException e) {
                    log.error("Error attempting to connect to XTM.", (Throwable)e);
                }
            } else {
                this.setVerificationStatus(jw, "Invalid User ID");
                log.debug("Invalid User ID");
                response.setStatus(400);
            }
        }
    }

    private void setVerificationStatus(JsonWriter jw, String errorMessage) throws IOException {
        jw.beginObject().name("verified").value(StringUtils.isBlank((CharSequence)errorMessage)).name("errorMessage").value(errorMessage).endObject();
    }

    private void writeAsJsonArray(Writer writer, String objectName, Map<String, String> entries) throws IOException {
        try (JsonWriter jw = this.gson.newJsonWriter(writer);){
            jw.beginObject().name(objectName).beginArray();
            for (Map.Entry<String, String> workflowRecord : entries.entrySet()) {
                jw.beginObject().name("id").value(workflowRecord.getKey()).name("name").value(workflowRecord.getValue()).endObject();
            }
            jw.endArray().endObject();
        }
    }
}

