/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl.servlets;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.config.http.ProxyConfigurationProvider;
import com.xtm.aem.models.config.TranslationCloudConfigPojo;
import com.xtm.aem.soap.legacy.RetrieveAllCustomersSoapAction;
import com.xtm.aem.soap.legacy.RetrieveTemplatesSoapAction;
import com.xtm.aem.soap.legacy.RetrieveXtmInfoSoapAction;
import com.xtm.aem.soap.wsdl.XtmInfoResponseAPI;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={XtmDropdownDataProviderService.class}, property={"service.vendor=XTM Intl", "service.description=Provides data for dropdown lists to configure the XTM Service."})
public class XtmDropdownDataProviderService {
    private static final Logger log = LoggerFactory.getLogger(XtmDropdownDataProviderService.class);
    @Reference
    private CryptoSupport cryptoSupport;
    @Reference
    private ProxyConfigurationProvider proxyProvider;
    private String webserviceUri;
    private String webserviceClient;
    private Long webserviceUserId;
    private String webservicePassword;
    private TranslationCloudConfig xtmCloudConfig;
    private boolean connectionVerified = false;

    void init(String webserviceUri, String webserviceClient, Long webserviceUserId, String webservicePassword) {
        log.trace("Initializing XTM Dropdown Data provider.");
        this.webserviceUri = webserviceUri;
        this.webserviceClient = webserviceClient;
        this.webserviceUserId = webserviceUserId;
        if (this.cryptoSupport.isProtected(webservicePassword)) {
            String unencrypted = null;
            try {
                unencrypted = this.cryptoSupport.unprotect(webservicePassword);
            }
            catch (CryptoException e) {
                log.error("Unable to unprotect password for XTM Service {}", (Object)e.getMessage());
            }
            this.webservicePassword = unencrypted;
        } else {
            this.webservicePassword = webservicePassword;
        }
        this.connectionVerified = false;
    }

    String canConnect() {
        log.trace("Verifying connection to XTM.");
        if (!this.connectionVerified) {
            if (!this.isConfigured()) {
                return "Incomplete configuration";
            }
            this.xtmCloudConfig = new TranslationCloudConfigPojo(this.webserviceUri, this.webserviceClient, this.webserviceUserId, this.webservicePassword, this.cryptoSupport, this.proxyProvider);
            RetrieveXtmInfoSoapAction action = new RetrieveXtmInfoSoapAction(this.xtmCloudConfig);
            try {
                XtmInfoResponseAPI xtmResponse = (XtmInfoResponseAPI)action.runWithHandlers();
                if (xtmResponse == null) {
                    return "No response from XTM Service";
                }
            }
            catch (TranslationException e) {
                log.debug("Error retrieving XTM Service information. {} ", (Object)e.getMessage());
                return e.getMessage();
            }
        }
        return "";
    }

    private boolean isConfigured() {
        return !this.webserviceUri.isEmpty() && !this.webserviceClient.isEmpty() && this.webserviceUserId != 0L && !this.webservicePassword.isEmpty();
    }

    Map<String, String> getAvailableTranslationCustomers() {
        log.trace("XtmDropdownDataProviderService.getAvailableTranslationCustomers");
        RetrieveAllCustomersSoapAction action = new RetrieveAllCustomersSoapAction(this.xtmCloudConfig);
        try {
            return (Map)action.runWithHandlers();
        }
        catch (TranslationException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    Map<String, String> getAvailableTranslationWorkflows(Long customerId) {
        log.trace("XtmDropdownDataProviderService.getAvailableTranslationWorkflows");
        RetrieveTemplatesSoapAction action = new RetrieveTemplatesSoapAction(customerId, this.xtmCloudConfig);
        try {
            return (Map)action.runWithHandlers();
        }
        catch (TranslationException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public TranslationCloudConfig getXtmCloudConfig() {
        return this.xtmCloudConfig;
    }
}

