/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.models;

import com.google.common.collect.ImmutableMap;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.raw.RawTranslationProject;
import com.xtm.aem.api.raw.RawTranslationProjectManager;
import com.xtm.aem.api.xtm.AemTranslationProject;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

public class ComplexAemTranslationProjectManager {
    private static final Map<String, String> rawPathToProjectPathCache = new HashMap<String, String>();

    public static AemTranslationProject getOrAdd(ResourceResolver resourceResolver, String aemTranslationJobId) throws PersistenceException {
        return ComplexAemTranslationProjectManager.getOrAdd(resourceResolver, aemTranslationJobId, null);
    }

    public static AemTranslationProject getOrAdd(ResourceResolver resourceResolver, String aemTranslationJobId, TranslationCloudConfig config) throws PersistenceException {
        RawTranslationProject rawProject = ((RawTranslationProjectManager)resourceResolver.adaptTo(RawTranslationProjectManager.class)).get(aemTranslationJobId);
        if (rawProject == null) {
            return null;
        }
        return ComplexAemTranslationProjectManager.getOrAdd(resourceResolver, rawProject, config);
    }

    public static AemTranslationProject getOrAdd(ResourceResolver resourceResolver, RawTranslationProject rawProject) throws PersistenceException {
        return ComplexAemTranslationProjectManager.getOrAdd(resourceResolver, rawProject, null);
    }

    public static AemTranslationProject getOrAdd(ResourceResolver resourceResolver, RawTranslationProject rawProject, TranslationCloudConfig config) throws PersistenceException {
        AemTranslationProject project = ComplexAemTranslationProjectManager.getExisting(resourceResolver, rawProject);
        if (project == null && rawProject != null) {
            project = ComplexAemTranslationProjectManager.createNew(resourceResolver, rawProject);
            project.setReference(rawProject);
            project.setReference(config);
        }
        return project;
    }

    public static AemTranslationProject getExisting(ResourceResolver resourceResolver, RawTranslationProject rawProject) {
        if (rawProject == null) {
            return null;
        }
        AemTranslationProject existing = ComplexAemTranslationProjectManager.getExisting(resourceResolver, rawProject.getPath());
        if (existing != null) {
            existing.setReference(rawProject);
        }
        return existing;
    }

    public static AemTranslationProject getExisting(ResourceResolver resourceResolver, String rawProjectPath) {
        Resource projectResource;
        if (StringUtils.isBlank((CharSequence)rawProjectPath)) {
            return null;
        }
        String cachedPath = rawPathToProjectPathCache.get(rawProjectPath);
        if (StringUtils.isNotBlank((CharSequence)cachedPath) && (projectResource = resourceResolver.getResource(cachedPath)) != null) {
            return (AemTranslationProject)projectResource.adaptTo(AemTranslationProject.class);
        }
        Resource root = resourceResolver.getResource("/var/xtm/translationProjects");
        if (root != null) {
            for (Resource projectResource2 : root.getChildren()) {
                if (!((String)projectResource2.getValueMap().get("aemProjectPath", (Object)"")).equals(rawProjectPath)) continue;
                AemTranslationProject existingProject = (AemTranslationProject)projectResource2.adaptTo(AemTranslationProject.class);
                if (existingProject == null) {
                    throw new IllegalStateException("Project representation of '" + rawProjectPath + "' found under '" + projectResource2.getPath() + "' but could not be adapted to internal representation");
                }
                rawPathToProjectPathCache.put(rawProjectPath, existingProject.getPath());
                return existingProject;
            }
        }
        return null;
    }

    private static AemTranslationProject createNew(ResourceResolver resourceResolver, RawTranslationProject rawProject) throws PersistenceException {
        Resource projectRootResource = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)"/var/xtm/translationProjects", (String)"nt:unstructured", (String)"nt:unstructured", (boolean)false);
        String projectResourceName = ResourceUtil.createUniqueChildName((Resource)projectRootResource, (String)"project");
        ImmutableMap properties = ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"nt:unstructured").put((Object)"aemProjectPath", (Object)rawProject.getPath()).put((Object)"aemTranslationJobIds", (Object)ArrayUtils.EMPTY_STRING_ARRAY).put((Object)"xtmProjectIds", (Object)ArrayUtils.EMPTY_LONG_ARRAY).put((Object)"finishedXtmProjectIds", (Object)ArrayUtils.EMPTY_LONG_ARRAY).put((Object)"aemConfigFolder", (Object)rawProject.getConfigFolder()).build();
        Resource atpResource = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)("/var/xtm/translationProjects/" + projectResourceName), (Map)properties, (String)"nt:unstructured", (boolean)false);
        rawPathToProjectPathCache.put(rawProject.getPath(), atpResource.getPath());
        return (AemTranslationProject)atpResource.adaptTo(AemTranslationProject.class);
    }
}

