/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.openapi.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.Configuration;
import com.xtm.aem.rest.openapi.Pair;
import com.xtm.aem.rest.openapi.model.RSAssignmentResponse;
import com.xtm.aem.rest.openapi.model.RSProjectDueDateUpdateRequest;
import com.xtm.aem.rest.openapi.model.RSProjectDueDateUpdateResponse;
import com.xtm.aem.rest.openapi.model.RSProjectJobsWorkflowPatchRequest;
import com.xtm.aem.rest.openapi.model.RSProjectJobsWorkflowPatchResponse;
import com.xtm.aem.rest.openapi.model.RSProjectUsersResponse;
import com.xtm.aem.rest.openapi.model.RSProjectWorkflowFinishResponse;
import com.xtm.aem.rest.openapi.model.RSProjectWorkflowRejectResponse;
import com.xtm.aem.rest.openapi.model.RSProjectWorkflowStartResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProjectWorkflowsApi {
    private ApiClient apiClient;

    public ProjectWorkflowsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectWorkflowsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RSProjectWorkflowFinishResponse finishWorkflowUsingPOST(String authorization, Long projectId, List<Long> jobIds, String mailing) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling finishWorkflowUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling finishWorkflowUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/workflow/finish".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "jobIds", jobIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("mailing", mailing));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectWorkflowFinishResponse> localVarReturnType = new TypeReference<RSProjectWorkflowFinishResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<RSAssignmentResponse> getAssignmentUsingGET(String authorization, Long projectId, List<Long> jobIds, Integer page, Integer pageSize, List<String> targetLanguages) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getAssignmentUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getAssignmentUsingGET");
        }
        String localVarPath = "/projects/{projectId}/workflow/assignment".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "jobIds", jobIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "targetLanguages", targetLanguages));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<List<RSAssignmentResponse>> localVarReturnType = new TypeReference<List<RSAssignmentResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectUsersResponse getProjectUsersUsingGET(String authorization, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getProjectUsersUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getProjectUsersUsingGET");
        }
        String localVarPath = "/projects/{projectId}/users".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectUsersResponse> localVarReturnType = new TypeReference<RSProjectUsersResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<RSProjectJobsWorkflowPatchResponse> patchJobsWorkflowUsingPATCH(String authorization, Long projectId, List<RSProjectJobsWorkflowPatchRequest> workflowPatchRequest) throws ApiException {
        List<RSProjectJobsWorkflowPatchRequest> localVarPostBody = workflowPatchRequest;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling patchJobsWorkflowUsingPATCH");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling patchJobsWorkflowUsingPATCH");
        }
        if (workflowPatchRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowPatchRequest' when calling patchJobsWorkflowUsingPATCH");
        }
        String localVarPath = "/projects/{projectId}/workflow/jobs".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<List<RSProjectJobsWorkflowPatchResponse>> localVarReturnType = new TypeReference<List<RSProjectJobsWorkflowPatchResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectWorkflowRejectResponse rejectWorkflowUsingPOST(String authorization, Long projectId, List<Long> jobIds, String mailing) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling rejectWorkflowUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling rejectWorkflowUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/workflow/reject".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "jobIds", jobIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("mailing", mailing));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectWorkflowRejectResponse> localVarReturnType = new TypeReference<RSProjectWorkflowRejectResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectWorkflowStartResponse startWorkflowUsingPOST(String authorization, Long projectId, List<Long> jobIds, List<String> targetLanguages) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling startWorkflowUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling startWorkflowUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/workflow/start".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "jobIds", jobIds));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "targetLanguages", targetLanguages));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectWorkflowStartResponse> localVarReturnType = new TypeReference<RSProjectWorkflowStartResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectDueDateUpdateResponse updateDueDatesUsingPUT(String authorization, Long projectId, RSProjectDueDateUpdateRequest dueDateUpdateRequest, List<String> targetLanguages) throws ApiException {
        RSProjectDueDateUpdateRequest localVarPostBody = dueDateUpdateRequest;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling updateDueDatesUsingPUT");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling updateDueDatesUsingPUT");
        }
        if (dueDateUpdateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'dueDateUpdateRequest' when calling updateDueDatesUsingPUT");
        }
        String localVarPath = "/projects/{projectId}/due-dates".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "targetLanguages", targetLanguages));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectDueDateUpdateResponse> localVarReturnType = new TypeReference<RSProjectDueDateUpdateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

