/******************************************
 *
 * Copyright (c) 2003-2010 XML-INTL Ltd.
 *
 * All Rights Reserved
 *
 ******************************************/

/* global jQuery */

(function ($, document, ready) {
  "use strict";

  var form,
      includeSubPagesCheckbox,
      autoStartProjectCheckbox,
      pagePathInput,
      errorDialog,
      jobTranslationPath,
      xtmConfigInput;

  function init() {
    bindDOM();
    bindEvents();
  }

  function bindDOM() {
    form = document.querySelector('form');
    includeSubPagesCheckbox = document.querySelector("[name='xtmIncludeSubPages']");
    autoStartProjectCheckbox = document.querySelector("[name='xtmAutoStartProject']");
    pagePathInput = document.querySelector("[name='xtmPagePath']");
    xtmConfigInput = document.querySelector("[name='xtmConfig']");
    errorDialog = document.querySelector('#error-dialog');
  }

  function bindEvents() {
    $(document).on('submit.publishWizard', '.cq-siteadmin-admin-send-to-translation-in-xtm-form', onFormSubmit);
  }

  function getData() {
    var data = $(form).serializeArray();
    data.push({name: 'xtmConfig', value: xtmConfigInput.value});
    return data
  }

  function createTranslationProject(data) {
    return new Promise(function (resolve, reject) {
      $.ajax({
        type: "POST",
        url: '/services/xtm/xtm-translation-project',
        data: data,
        success: function (data) {
          resolve(data)
        },
        error: function (error) {
          reject(error)
        }
      })
    });
  }

  function addPagesToTranslationJobs(data) {
    var map = data.languageToTranslationJobPath;
    var promises = [];
    Object.keys(map).forEach(function (key) {
      promises.push(addPagesToTranslationJob(data.projectPath, map[key]));
    });
    return Promise.all(promises);
  }

  function startTranslationJobs(data) {
    var promises = [];
    data.forEach(function (pagesPromise) {
      promises.push(startTranslationJob(pagesPromise.projectPath, pagesPromise.translationGadgetPath));
    });
    return Promise.all(promises);
  }

  function addPagesToTranslationJob(projectPath, translationGadgetPath) {
    var data = new FormData();
    data.append(":translationJobPath", translationGadgetPath);
    data.append("_charset_", "UTF-8");
    data.append("createLanguageCopy", "true");
    data.append(":operation", "ADD_TRANSLATION_PAGES");
    data.append("allowChildren", includeSubPagesCheckbox.checked);
    data.append("translationpage", pagePathInput.value);

    return new Promise(function (resolve, reject) {
      $.ajax({
        type: "POST",
        url: translationGadgetPath,
        enctype: 'multipart/form-data',
        data: data,
        processData: false,
        contentType: false,
        dataType: 'json',
        success: function () {
          resolve({
            projectPath: projectPath,
            translationGadgetPath: translationGadgetPath
          })
        },
        error: function (error) {
          reject(error)
        }
      });
    });
  }

  function startTranslationJob(projectPath, translationGadgetPath) {
    return new Promise(function (resolve, reject) {
      if (autoStartProjectCheckbox.checked) {
        var data = new FormData();
        data.append(":translationJobPath", translationGadgetPath);
        data.append(":operation", "START_TRANSLATION");

        $.ajax({
          type: "POST",
          url: translationGadgetPath,
          enctype: 'multipart/form-data',
          data: data,
          processData: false,
          contentType: false,
          dataType: 'json',
          success: function () {
            resolve({
              projectPath: projectPath,
              translationGadgetPath: translationGadgetPath
            })
          },
          error: function (error) {
            reject(error)
          }
        });
      } else {
        resolve({
          projectPath: projectPath,
          translationGadgetPath: translationGadgetPath
        });
      }
    });
  }

  function showPreloader() {
    var elem = document.querySelector('.foundation-ui-mask');
    if (!elem) {
      var preloader = document.createElement('div');
      var wait = new Coral.Wait().set({
        size: "L",
        centered: true
      });
      preloader.setAttribute('class', 'foundation-ui-mask');
      preloader.append(wait);
      document.body.append(preloader);
    }
  }

  function hidePreloader() {
    var elem = document.querySelector('.foundation-ui-mask');
    if (elem) {
      elem.remove();
    }
  }

  function handleError(e) {
    var title = e.title || e.statusText || 'Error';
    var description = e.description || e.responseText || 'Unknown error';
    var titleElem = errorDialog.querySelector('.coral3-Dialog-header > div');
    var contentElem = errorDialog.querySelector('.coral3-Dialog-content > div');
    titleElem.innerText = title;
    contentElem.innerText = description;
    console.error(description, e);
    errorDialog.show();
  }

  function handleSuccess(action) {
    return function (promises) {
      var data = promises[0];

      return new Promise(function (resolve, reject) {
        if (action === 'save-and-open-project' && data.projectPath) {
          document.location = '/projects/details.html' + data.projectPath;
          resolve();
        } else if (action === 'save-and-close') {
          document.location = '/editor.html' + pagePathInput.value + '.html';
          resolve();
        } else {
          reject("Invalid action type: " + action);
        }
      });
    }
  }

  function onFormSubmit(e) {
    e.preventDefault();
    var submitButton = e.delegateTarget.activeElement;
    var action = submitButton.getAttribute('value');
    if (!action) {
      return;
    }

    submitButton.setAttribute('disabled', 'disabled');
    showPreloader();

    createTranslationProject(getData())
        .then(addPagesToTranslationJobs)
        .then(startTranslationJobs)
        .then(handleSuccess(action))
        .catch(handleError)
        .finally(function () {
          hidePreloader();
          submitButton.removeAttribute('disabled');
        });
  }

  $(document).on('foundation-contentloaded', function () {
    ready(this, init);
  });
})(jQuery, document, Coral.commons.ready);
