/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.models.config;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.xtm.aem.api.config.LaunchHandlingStrategy;
import com.xtm.aem.api.config.PreviewGenerationStrategy;
import com.xtm.aem.api.config.ProjectCancellationStrategy;
import com.xtm.aem.api.config.ProjectCreationStrategy;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.config.XtmJobFileNamingStrategy;
import com.xtm.aem.api.config.http.ProxyConfigurationProvider;
import com.xtm.aem.models.config.RawLanguageMappingModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.http.osgi.services.ProxyConfiguration;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={Resource.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class TranslationCloudConfigModel
implements TranslationCloudConfig {
    @Self
    private Resource resource;
    @OSGiService
    private ProxyConfigurationProvider proxyConfigurationProvider;
    @OSGiService
    private CryptoSupport cryptoSupport;
    @ValueMapValue(name="jcr:content/xtmWebserviceURI")
    private String webserviceUri;
    @ValueMapValue(name="jcr:content/xtmClientname")
    private String client;
    @ValueMapValue(name="jcr:content/xtmUserId")
    private Long userId;
    @ValueMapValue(name="jcr:content/xtmPassword")
    private String password;
    @ValueMapValue(name="jcr:content/xtmProjectManagerId")
    private Long projectManagerId;
    @ValueMapValue(name="jcr:content/selectedCustomerId")
    private Long customerId;
    @ValueMapValue(name="jcr:content/selectedTemplateId")
    private Long templateId;
    @ValueMapValue(name="jcr:content/projectCreationStrategyRaw")
    private String projectCreationStrategyRaw;
    @ValueMapValue(name="jcr:content/advanced/xtmJobFileNamingStrategyRaw")
    @Default(values={"TITLE_BASED"})
    private String xtmJobFileNamingStrategyRaw;
    @ValueMapValue(name="jcr:content/advanced/projectCancellationStrategyRaw")
    private String projectCancellationStrategyRaw;
    @ValueMapValue(name="jcr:content/launchHandlingStrategyRaw")
    private String launchHandlingStrategyRaw;
    @ValueMapValue(name="jcr:content/advanced/languageMappingPath")
    @Default(values={"/apps/xtm/config/xtm/languageMapping"})
    private String languageMappingPath;
    @ValueMapValue(name="jcr:content/advanced/projectNameTemplate")
    @Default(values={"[AEM $SOURCE_LANGUAGE - $TARGET_LANGUAGE] $AEM_TITLE"})
    private String projectNameTemplate;
    @ValueMapValue(name="jcr:content/advanced/previewGenerationStrategyRaw")
    @Default(values={"XTM"})
    private String previewGenerationStrategyRaw;
    @ValueMapValue(name="jcr:content/advanced/analysisCheckMaxRetries")
    @Default(intValues={2000})
    private Integer analysisCheckMaxRetries;
    @ValueMapValue(name="jcr:content/advanced/analysisCheckRetryInterval")
    @Default(intValues={2000})
    private Integer analysisCheckRetryInterval;
    @ValueMapValue(name="jcr:content/callback/analysisFinished")
    private String analysisFinishedCallback;
    @ValueMapValue(name="jcr:content/callback/workflowTransition")
    private String workflowTransitionCallback;
    @ValueMapValue(name="jcr:content/callback/jobFinished")
    private String jobFinishedCallback;
    @ValueMapValue(name="jcr:content/callback/projectFinished")
    private String projectFinishedCallback;
    private ProjectCreationStrategy projectCreationStrategy;
    private XtmJobFileNamingStrategy xtmJobFileNamingStrategy;
    private ProjectCancellationStrategy projectCancellationStrategy;
    private LaunchHandlingStrategy launchHandlingStrategy;
    private PreviewGenerationStrategy previewGenerationStrategy;
    private String path = "";
    private String folderPath = "";
    private final Map<String, String> languageMapping = new HashMap<String, String>();

    @PostConstruct
    protected void postConstruct() {
        this.path = this.resource.getPath();
        this.folderPath = this.resource.getParent().getParent().getParent().getParent().getParent().getPath();
        this.languageMapping.putAll(this.getLanguageMapping("/apps/xtm/mappings/languageMapping", this.resource.getResourceResolver()));
        if (!StringUtils.equals((CharSequence)"/apps/xtm/mappings/languageMapping", (CharSequence)this.languageMappingPath)) {
            this.getLanguageMapping(this.languageMappingPath, this.resource.getResourceResolver()).forEach((sourceLanguage, targetLanguage) -> {
                if (StringUtils.isBlank((CharSequence)targetLanguage)) {
                    this.languageMapping.remove(sourceLanguage);
                } else {
                    this.languageMapping.put((String)sourceLanguage, (String)targetLanguage);
                }
            });
        }
        this.projectManagerId = (Long)ObjectUtils.defaultIfNull((Object)this.projectManagerId, (Object)this.userId);
    }

    @Override
    public String getWebserviceUri() {
        return this.webserviceUri;
    }

    @Override
    public String getClient() {
        return this.client;
    }

    @Override
    public Long getUserId() {
        return this.userId;
    }

    @Override
    public String getPassword() {
        try {
            return this.cryptoSupport != null && this.cryptoSupport.isProtected(this.password) ? this.cryptoSupport.unprotect(this.password) : this.password;
        }
        catch (CryptoException e) {
            throw new IllegalStateException("Could not decrypt password", e);
        }
    }

    @Override
    public Long getProjectManagerId() {
        return this.projectManagerId;
    }

    @Override
    public Long getCustomerId() {
        return this.customerId;
    }

    @Override
    public Long getTemplateId() {
        return this.templateId;
    }

    @Override
    public ProjectCreationStrategy getProjectCreationStrategy() {
        if (this.projectCreationStrategy == null) {
            this.projectCreationStrategy = StringUtils.isNotBlank((CharSequence)this.projectCreationStrategyRaw) ? ProjectCreationStrategy.valueOf(this.projectCreationStrategyRaw) : ProjectCreationStrategy.NEW_PROJECT;
        }
        return this.projectCreationStrategy;
    }

    public String getProjectCreationStrategyRaw() {
        return this.projectCreationStrategyRaw;
    }

    @Override
    public XtmJobFileNamingStrategy getXtmJobFileNamingStrategy() {
        if (this.xtmJobFileNamingStrategy == null) {
            this.xtmJobFileNamingStrategy = StringUtils.isNotBlank((CharSequence)this.xtmJobFileNamingStrategyRaw) ? XtmJobFileNamingStrategy.valueOf(this.xtmJobFileNamingStrategyRaw) : XtmJobFileNamingStrategy.TITLE_BASED;
        }
        return this.xtmJobFileNamingStrategy;
    }

    public String getXtmJobFileNamingStrategyRaw() {
        return this.xtmJobFileNamingStrategyRaw;
    }

    @Override
    public ProjectCancellationStrategy getProjectCancellationStrategy() {
        if (this.projectCancellationStrategy == null) {
            this.projectCancellationStrategy = StringUtils.isNotBlank((CharSequence)this.projectCancellationStrategyRaw) ? ProjectCancellationStrategy.valueOf(this.projectCancellationStrategyRaw) : ProjectCancellationStrategy.ARCHIVE;
        }
        return this.projectCancellationStrategy;
    }

    public String getProjectCancellationStrategyRaw() {
        return this.projectCancellationStrategyRaw;
    }

    @Override
    public LaunchHandlingStrategy getLaunchHandlingStrategy() {
        if (this.launchHandlingStrategy == null) {
            this.launchHandlingStrategy = this.getProjectCreationStrategy() == ProjectCreationStrategy.NEW_PROJECT ? LaunchHandlingStrategy.SEPARATE : (StringUtils.isNotBlank((CharSequence)this.launchHandlingStrategyRaw) ? LaunchHandlingStrategy.valueOf(this.launchHandlingStrategyRaw) : LaunchHandlingStrategy.SEPARATE);
        }
        return this.launchHandlingStrategy;
    }

    public String getLaunchHandlingStrategyRaw() {
        return this.launchHandlingStrategyRaw;
    }

    @Override
    public PreviewGenerationStrategy getPreviewGenerationStrategy() {
        if (this.previewGenerationStrategy == null) {
            this.previewGenerationStrategy = StringUtils.isNotBlank((CharSequence)this.previewGenerationStrategyRaw) ? PreviewGenerationStrategy.valueOf(this.previewGenerationStrategyRaw) : PreviewGenerationStrategy.XTM;
        }
        return this.previewGenerationStrategy;
    }

    public String getPreviewGenerationStrategyRaw() {
        return this.previewGenerationStrategyRaw;
    }

    @Override
    public String getAnalysisFinishedCallback() {
        return this.analysisFinishedCallback;
    }

    @Override
    public String getWorkflowTransitionCallback() {
        return this.workflowTransitionCallback;
    }

    @Override
    public String getJobFinishedCallback() {
        return this.jobFinishedCallback;
    }

    @Override
    public String getProjectFinishedCallback() {
        return this.projectFinishedCallback;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getFolderPath() {
        return this.folderPath;
    }

    @Override
    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfigurationProvider.getProxyConfiguration(this.webserviceUri);
    }

    @Override
    public Map<String, String> getLanguageMapping() {
        return this.languageMapping;
    }

    public String getLanguageMappingPath() {
        return this.languageMappingPath;
    }

    @Override
    public String getProjectNameTemplate() {
        return this.projectNameTemplate;
    }

    @Override
    public Integer getAnalysisCheckMaxRetries() {
        return this.analysisCheckMaxRetries;
    }

    @Override
    public Integer getAnalysisCheckRetryInterval() {
        return this.analysisCheckRetryInterval;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TranslationCloudConfigModel other = (TranslationCloudConfigModel)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.path, (Object)other.path).append((Object)this.webserviceUri, (Object)other.webserviceUri).append((Object)this.client, (Object)other.client).append((Object)this.userId, (Object)other.userId).append((Object)this.password, (Object)other.password).append((Object)this.customerId, (Object)other.customerId).append((Object)this.templateId, (Object)other.templateId).append((Object)this.analysisFinishedCallback, (Object)other.analysisFinishedCallback).append((Object)this.workflowTransitionCallback, (Object)other.workflowTransitionCallback).append((Object)this.jobFinishedCallback, (Object)other.jobFinishedCallback).append((Object)this.projectFinishedCallback, (Object)other.projectFinishedCallback).append((Object)this.projectCreationStrategyRaw, (Object)other.projectCreationStrategyRaw).append((Object)this.launchHandlingStrategyRaw, (Object)other.launchHandlingStrategyRaw).append((Object)this.analysisCheckMaxRetries, (Object)other.analysisCheckMaxRetries).append((Object)this.analysisCheckRetryInterval, (Object)other.analysisCheckRetryInterval).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 9).append((Object)this.path).append((Object)this.webserviceUri).append((Object)this.client).append((Object)this.userId).append((Object)this.password).append((Object)this.customerId).append((Object)this.templateId).append((Object)this.analysisFinishedCallback).append((Object)this.workflowTransitionCallback).append((Object)this.jobFinishedCallback).append((Object)this.projectFinishedCallback).append((Object)this.projectCreationStrategyRaw).append((Object)this.launchHandlingStrategyRaw).append((Object)this.analysisCheckMaxRetries).append((Object)this.analysisCheckRetryInterval).toHashCode();
    }

    private Map<String, String> getLanguageMapping(String path, ResourceResolver resolver2) {
        Resource mappingRoot = resolver2.getResource(path);
        if (mappingRoot == null) {
            return Collections.emptyMap();
        }
        RawLanguageMappingModel mappingModel = (RawLanguageMappingModel)mappingRoot.adaptTo(RawLanguageMappingModel.class);
        if (mappingModel == null) {
            return Collections.emptyMap();
        }
        return mappingModel.getLanguageMapping();
    }
}

