/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.models.xtm;

import com.adobe.granite.translation.api.TranslationConstants;
import com.google.common.collect.ImmutableList;
import com.xtm.aem.api.raw.RawTranslationJob;
import com.xtm.aem.api.raw.RawTranslationProject;
import com.xtm.aem.api.raw.RawTranslationProjectManager;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.api.xtm.AemTranslationProject;
import com.xtm.translation.connector.xtmforaem.core.models.ComplexAemTranslationProjectManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ChildResource;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, adapters={AemTranslationJob.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class AemTranslationJobModel
implements AemTranslationJob {
    private static final Logger log = LoggerFactory.getLogger(AemTranslationJobModel.class);
    @Self
    private Resource resource;
    @Self
    private ModifiableValueMap mvm;
    @ValueMapValue
    private String aemJobId;
    @ValueMapValue
    private String sourceLanguage;
    @ValueMapValue
    private String targetLanguage;
    @ValueMapValue
    private String xtmProjectName;
    @ValueMapValue
    private String description;
    @ChildResource(name="objects")
    private List<AemTranslationObject> aemTranslationObjects = new ArrayList<AemTranslationObject>();
    @ValueMapValue
    private Date dueDate;
    @ValueMapValue
    private Long xtmProjectId;
    @ValueMapValue
    private String translationStatusRaw;
    private TranslationConstants.TranslationStatus translationStatus;
    @ValueMapValue
    private boolean sentToXtm;
    private Map<String, AemTranslationObject> atoMapping;
    private AemTranslationProject project;
    private RawTranslationJob rawJob;

    @PostConstruct
    protected void postConstruct() {
        this.aemTranslationObjects.forEach(ato -> ato.setReference(this));
        this.atoMapping = this.aemTranslationObjects.stream().collect(Collectors.toMap(AemTranslationObject::getAemTranslationObjectId, Function.identity()));
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public void markAsSentToXtm() {
        this.sentToXtm = true;
        this.mvm.put((Object)"sentToXtm", (Object)true);
    }

    @Override
    public void setXtmProjectId(Long xtmProjectId) {
        this.xtmProjectId = xtmProjectId;
        this.mvm.put((Object)"xtmProjectId", (Object)xtmProjectId);
    }

    @Override
    public Collection<AemTranslationObject> getAemTranslationObjects() {
        return ImmutableList.copyOf(this.aemTranslationObjects);
    }

    @Override
    public AemTranslationObject getAemTranslationObject(String aemTranslationObjectId) {
        AemTranslationObject ato = this.atoMapping.get(aemTranslationObjectId);
        if (ato == null) {
            throw new IllegalArgumentException("Could not find AEM Translation Object '" + aemTranslationObjectId + "' within AEM Translation Job '" + this.getAemJobId() + "'");
        }
        return ato;
    }

    @Override
    public void addAemTranslationObject(AemTranslationObject aemTranslationObject) {
        if (this.hasAemTranslationObject(aemTranslationObject.getAemTranslationObjectId())) {
            return;
        }
        aemTranslationObject.setReference(this.getProject());
        aemTranslationObject.setReference(this);
        this.atoMapping.put(aemTranslationObject.getAemTranslationObjectId(), aemTranslationObject);
        this.aemTranslationObjects.add(aemTranslationObject);
    }

    @Override
    public boolean hasAemTranslationObject(String aemTranslationObjectId) {
        return this.atoMapping.containsKey(aemTranslationObjectId);
    }

    @Override
    public TranslationConstants.TranslationStatus getTranslationStatus() {
        if (this.translationStatus == null) {
            this.translationStatus = TranslationConstants.TranslationStatus.fromString((String)this.translationStatusRaw);
        }
        return this.translationStatus;
    }

    @Override
    public void setTranslationStatus(TranslationConstants.TranslationStatus newStatus) {
        this.translationStatus = newStatus;
        this.translationStatusRaw = newStatus.toString();
        this.mvm.put((Object)"translationStatusRaw", (Object)this.translationStatusRaw);
    }

    @Override
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
        this.mvm.put((Object)"dueDate", (Object)dueDate);
    }

    @Override
    public AemTranslationProject getProject() {
        if (this.project == null) {
            try {
                this.project = ComplexAemTranslationProjectManager.getOrAdd(this.resource.getResourceResolver(), this.aemJobId);
            }
            catch (PersistenceException e) {
                log.warn("Could not retrieve project for ATJ '{}'", (Object)this.aemJobId, (Object)e);
            }
        }
        return this.project;
    }

    @Override
    public RawTranslationJob getRawJob() {
        if (this.rawJob == null) {
            RawTranslationProjectManager rawTranslationProjectManager = (RawTranslationProjectManager)Objects.requireNonNull(this.resource.getResourceResolver().adaptTo(RawTranslationProjectManager.class));
            this.rawJob = rawTranslationProjectManager.get(this.aemJobId).getTranslationJob(this.aemJobId);
        }
        return this.rawJob;
    }

    @Override
    public void setReference(AemTranslationProject project) {
        if (project == null) {
            return;
        }
        this.project = project;
        RawTranslationProject rawProject = project.getRawProject();
        if (rawProject != null) {
            this.setReference(project.getRawProject().getTranslationJob(this.aemJobId));
        }
        this.aemTranslationObjects.forEach(ato -> ato.setReference(project));
        this.aemTranslationObjects.forEach(ato -> ato.setReference(this));
    }

    @Override
    public void setReference(RawTranslationJob rawJob) {
        if (rawJob == null) {
            return;
        }
        if (!StringUtils.equals((CharSequence)rawJob.getTranslationObjectId(), (CharSequence)this.aemJobId)) {
            throw new IllegalArgumentException("ID of the passed job does not match the expected one");
        }
        this.rawJob = rawJob;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public String getAemJobId() {
        return this.aemJobId;
    }

    @Override
    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    @Override
    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    @Override
    public String getXtmProjectName() {
        return this.xtmProjectName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public Long getXtmProjectId() {
        return this.xtmProjectId;
    }

    @Override
    public boolean isSentToXtm() {
        return this.sentToXtm;
    }
}

