/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.models.xtm;

import com.google.common.collect.ImmutableList;
import com.xtm.aem.api.xtm.TranslationEntry;
import com.xtm.aem.api.xtm.TranslationFile;
import com.xtm.aem.models.xtm.TranslationEntryModel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={Resource.class}, adapters={TranslationFile.class})
public class TranslationFileModel
implements TranslationFile {
    private static final Pattern TRANSLATION_PATTERN = Pattern.compile("<property isMultiValue=\"(.*?)\" nodePath=\"(.*?)\" propertyName=\"(.*?)\">(.*?)</property>", 32);
    @Self
    private Resource resource;
    private final Collection<TranslationEntry> entries = new ArrayList<TranslationEntry>();

    @PostConstruct
    protected void postConstruct() {
        String translationContent = this.getTranslationFileContent();
        if (translationContent == null) {
            return;
        }
        Matcher translationMatcher = TRANSLATION_PATTERN.matcher(translationContent);
        while (translationMatcher.find()) {
            boolean multivalue = "true".equals(translationMatcher.group(1));
            if (multivalue) continue;
            String path = translationMatcher.group(2);
            String propName = translationMatcher.group(3);
            String text = StringEscapeUtils.unescapeXml((String)translationMatcher.group(4)).trim();
            this.entries.add(new TranslationEntryModel(path, propName, (Collection<String>)ImmutableList.of((Object)text)));
        }
    }

    private String getTranslationFileContent() {
        byte[] bytes;
        try {
            InputStream is = (InputStream)Objects.requireNonNull(this.resource.adaptTo(InputStream.class));
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public Collection<TranslationEntry> getEntries() {
        return ImmutableList.copyOf(this.entries);
    }

    @Override
    public byte[] getBytes() {
        if (this.resource == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        try {
            InputStream is = (InputStream)Objects.requireNonNull(this.resource.adaptTo(InputStream.class));
            return IOUtils.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
    }
}

