/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.models.zip;

import com.xtm.aem.api.services.preview.PreviewZipEntry;
import com.xtm.aem.api.services.preview.PreviewZipFile;
import com.xtm.aem.models.zip.PreviewZipEntryModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={Resource.class}, adapters={PreviewZipFile.class})
public class PreviewZipFileModel
extends HashMap<String, PreviewZipEntry>
implements PreviewZipFile {
    @Inject
    public PreviewZipFileModel(@Self Resource resource) throws IOException {
        this((InputStream)resource.adaptTo(InputStream.class));
    }

    public PreviewZipFileModel(InputStream is) throws IOException {
        ZipInputStream zis = new ZipInputStream(is);
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            byte[] content = IOUtils.toByteArray((InputStream)zis);
            this.put(name, new PreviewZipEntryModel(name, content));
            entry = zis.getNextEntry();
        }
    }

    @Override
    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zipOut = new ZipOutputStream((OutputStream)baos);){
            for (PreviewZipEntry previewEntry : this.values()) {
                zipOut.putNextEntry(new ZipEntry(previewEntry.getName()));
                IOUtils.write((byte[])previewEntry.getContent(), (OutputStream)zipOut);
                zipOut.closeEntry();
            }
        }
        return baos.toByteArray();
    }

    @Override
    public PreviewZipEntry put(PreviewZipEntry entry) {
        return this.put(entry.getName(), entry);
    }

    @Override
    public PreviewZipEntry remove(PreviewZipEntry entry) {
        return (PreviewZipEntry)this.remove(entry.getName());
    }

    public PreviewZipFileModel() {
    }
}

