/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.XtmAction;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.rest.actions.BasePostAnalysisXtmRestAction;
import com.xtm.aem.rest.openapi.api.ProjectFilesApi;
import com.xtm.aem.rest.openapi.model.CUSTOMERLANGUAGEDEFINITIONS;
import com.xtm.aem.rest.openapi.model.RSJobStatusResponse;
import com.xtm.aem.rest.openapi.model.RSProjectAnalysisResponse;
import com.xtm.aem.rest.openapi.model.RSProjectFileDeleteResponse;
import com.xtm.aem.rest.openapi.model.RSProjectFileRemoveParameter;
import com.xtm.aem.rest.openapi.model.RSProjectStatusResponse;
import com.xtm.aem.rest.overrides.YesNoType;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTranslationFilesRestAction
extends BasePostAnalysisXtmRestAction<RSProjectFileDeleteResponse> {
    private static final Logger log = LoggerFactory.getLogger(DeleteTranslationFilesRestAction.class);
    private final Long projectId;
    private final Collection<CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum> languagesToDelete;
    private final Collection<String> filesToDelete;
    private final XtmAction<RSProjectStatusResponse> projectCompletionRestAction;

    public DeleteTranslationFilesRestAction(Long projectId, Collection<CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum> languagesToDelete, Collection<String> filesToDelete, TranslationCloudConfig cloudConfig, RestServicesWrapper restServicesWrapper, XtmAction<RSProjectAnalysisResponse> projectAnalysisCompletionRestAction, XtmAction<RSProjectStatusResponse> projectCompletionRestAction) {
        super(cloudConfig, restServicesWrapper, projectAnalysisCompletionRestAction);
        this.projectId = projectId;
        this.languagesToDelete = languagesToDelete;
        this.filesToDelete = filesToDelete;
        this.projectCompletionRestAction = projectCompletionRestAction;
    }

    @Override
    protected RSProjectFileDeleteResponse runAfterAnalysisFinished() throws Exception {
        log.trace("DeleteTranslationFilesRestAction.runInternal");
        log.info("Deleting files from project with ID '{}'...", (Object)this.projectId);
        List<RSProjectFileRemoveParameter> filesToDeleteFiltered = this.getFilesToDelete();
        if (this.noFilesToDelete(filesToDeleteFiltered)) {
            log.debug("No files to delete for project with ID '{}'", (Object)this.projectId);
            return null;
        }
        ProjectFilesApi projectFilesApi = new ProjectFilesApi(this.getApiClient());
        return projectFilesApi.deleteSourceFilesFromProjectUsingDELETE(this.getAccessToken(), this.projectId, filesToDeleteFiltered, YesNoType.NO.name());
    }

    private boolean noFilesToDelete(List<RSProjectFileRemoveParameter> filesToDelete) {
        return filesToDelete == null || CollectionUtils.isEmpty(filesToDelete);
    }

    protected List<RSProjectFileRemoveParameter> getFilesToDelete() throws TranslationException {
        return this.projectCompletionRestAction.run().getJobs().stream().filter(jobStatus -> this.languagesToDelete.contains((Object)CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum.fromValue(jobStatus.getTargetLanguage()))).filter(jobStatus -> RSJobStatusResponse.CompletionStatusEnum.IN_PROGRESS.equals((Object)jobStatus.getCompletionStatus())).map(RSJobStatusResponse::getFileName).distinct().filter(this.filesToDelete::contains).map(this::toRSProjectFileRemoveParameter).collect(Collectors.toList());
    }

    private RSProjectFileRemoveParameter toRSProjectFileRemoveParameter(String fileName) {
        RSProjectFileRemoveParameter parameter = new RSProjectFileRemoveParameter();
        parameter.setFileName(fileName);
        parameter.setLanguages(this.languagesToDelete.stream().map(CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum::getValue).collect(Collectors.toList()));
        return parameter;
    }
}

