/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.adobe.granite.translation.api.TranslationScope;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.rest.actions.BaseXtmRestAction;
import com.xtm.aem.rest.models.XtmTranslationScope;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.api.ProjectAnalyticsApi;
import com.xtm.aem.rest.openapi.api.ProjectLinksApi;
import com.xtm.aem.rest.openapi.api.ProjectsApi;
import com.xtm.aem.rest.openapi.model.ProjectEstimates;
import com.xtm.aem.rest.openapi.model.RSCoreMetrics;
import com.xtm.aem.rest.openapi.model.RSLanguageMetricsResponse;
import com.xtm.aem.rest.openapi.model.RSProjectEditorLinkResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObtainProjectScopeRestAction
extends BaseXtmRestAction<TranslationScope> {
    private static final Logger log = LoggerFactory.getLogger(ObtainProjectScopeRestAction.class);
    private final Long projectId;

    protected ObtainProjectScopeRestAction(Long projectId, TranslationCloudConfig cloudConfig, RestServicesWrapper restServicesWrapper) {
        super(cloudConfig, restServicesWrapper);
        this.projectId = projectId;
    }

    @Override
    protected TranslationScope runInternal() throws Exception {
        log.trace("ObtainProjectScopeRestAction.runInternal");
        XtmTranslationScope translationScope = new XtmTranslationScope();
        this.obtainEstimates(translationScope);
        this.obtainMetrics(translationScope);
        this.obtainProjectEditorLink(translationScope);
        return translationScope;
    }

    private void obtainEstimates(XtmTranslationScope translationScope) throws ApiException {
        log.trace("ObtainProjectScopeRestAction.obtainEstimates");
        ProjectsApi projectsApi = new ProjectsApi(this.getApiClient());
        ProjectEstimates response = projectsApi.findProposalUsingGET(this.getAccessToken(), this.projectId);
        translationScope.addScopeItem("TranslationScope:CostEstimate", response.getCurrency() + " " + response.getPrice());
    }

    private void obtainMetrics(XtmTranslationScope translationScope) throws ApiException {
        log.trace("ObtainProjectScopeRestAction.obtainMetrics");
        ProjectAnalyticsApi projectAnalyticsApi = new ProjectAnalyticsApi(this.getApiClient());
        RSCoreMetrics coreMetrics = projectAnalyticsApi.findProjectMetricsUsingGET(this.getAccessToken(), this.projectId, null).stream().findFirst().map(RSLanguageMetricsResponse::getCoreMetrics).orElse(null);
        if (coreMetrics == null) {
            throw new ApiException("Failed to obtain core metrics for project ID: " + this.projectId);
        }
        int wordCount = (Integer)ObjectUtils.defaultIfNull((Object)coreMetrics.getTotalWords(), (Object)0);
        translationScope.setWordCount(wordCount);
        translationScope.addScopeItem("Total Word Count", String.valueOf(wordCount));
        translationScope.addScopeItem("ICE Match", String.valueOf(coreMetrics.getIceMatchWords()));
        translationScope.addScopeItem("100% Match", String.valueOf(coreMetrics.getLeveragedWords()));
        translationScope.addScopeItem("Repetition", String.valueOf(coreMetrics.getRepeatsWords()));
        translationScope.addScopeItem("Machine Translation", String.valueOf(coreMetrics.getMachineTranslationWords()));
        Integer fuzzyMatchC1Words = coreMetrics.getLowFuzzyMatchWords();
        Integer fuzzyMatchC2Words = coreMetrics.getMediumFuzzyMatchWords();
        Integer fuzzyMatchC3Words = coreMetrics.getHighFuzzyMatchWords();
        if (null != fuzzyMatchC1Words && null != fuzzyMatchC2Words && null != fuzzyMatchC3Words) {
            translationScope.addScopeItem("99%-95% Match", String.valueOf(fuzzyMatchC1Words));
            translationScope.addScopeItem("94-85% Match", String.valueOf(fuzzyMatchC2Words));
            translationScope.addScopeItem("84-75% Match", String.valueOf(fuzzyMatchC3Words));
        }
    }

    private void obtainProjectEditorLink(XtmTranslationScope translationScope) throws ApiException {
        log.trace("ObtainProjectScopeRestAction.obtainProjectEditorLink");
        ProjectLinksApi projectLinksApi = new ProjectLinksApi(this.getApiClient());
        RSProjectEditorLinkResponse response = projectLinksApi.generateProjectEditorLinkUsingPOST(this.getAccessToken(), this.projectId, null);
        translationScope.addScopeItem("TranslationScope:DetailsLink", response.getUrl());
    }
}

