/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.xtm.aem.api.XtmAction;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.rest.actions.BasePostAnalysisXtmRestAction;
import com.xtm.aem.rest.openapi.api.ProjectStatesApi;
import com.xtm.aem.rest.openapi.model.RSProjectAnalysisResponse;
import com.xtm.aem.rest.openapi.model.RSProjectStatusResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectCompletionRestAction
extends BasePostAnalysisXtmRestAction<RSProjectStatusResponse> {
    private static final Logger log = LoggerFactory.getLogger(ProjectCompletionRestAction.class);
    private final Long projectId;

    protected ProjectCompletionRestAction(Long projectId, TranslationCloudConfig cloudConfig, RestServicesWrapper restServicesWrapper, XtmAction<RSProjectAnalysisResponse> projectAnalysisCompletionRestAction) {
        super(cloudConfig, restServicesWrapper, projectAnalysisCompletionRestAction);
        this.projectId = projectId;
    }

    @Override
    protected RSProjectStatusResponse runAfterAnalysisFinished() throws Exception {
        log.trace("ProjectCompletionRestAction.runAfterAnalysisFinished");
        ProjectStatesApi projectStatesApi = new ProjectStatesApi(this.getApiClient());
        RSProjectStatusResponse response = projectStatesApi.checkProjectStatusesUsingGET(this.getAccessToken(), this.projectId, "JOBS", null, null, null);
        log.debug("Project [{}], status: {}", (Object)this.projectId, (Object)response.getCompletionStatus());
        return response;
    }
}

