/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.client;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.xtm.aem.api.rest.OauthAccessTokenModel;
import java.sql.Timestamp;
import org.apache.commons.lang3.ObjectUtils;

public class OauthAccessTokenResponse
implements OauthAccessTokenModel {
    public static final String JSON_PROPERTY_ACCESS_TOKEN = "access_token";
    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refresh_token";
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    public static final String JSON_PROPERTY_EXPIRES_IN = "expires_in";
    public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
    public static final String JSON_PROPERTY_IS_EXPIRED = "is_expired";
    public static final String JSON_PROPERTY_TOKEN_TYPE = "token_type";
    public static final String JSON_PROPERTY_SCOPE = "scope";
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="refresh_token")
    private String refreshToken;
    @JsonProperty(value="token_type")
    private String tokenType;
    @JsonProperty(value="scope")
    private String scope;
    private long leaseTime;
    @JsonProperty(value="created_at")
    private final Timestamp createdAt = this.now();

    private Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    @JsonSetter(value="expires_in")
    public void setLeaseTime(long leaseTime) {
        this.leaseTime = (Long)ObjectUtils.defaultIfNull((Object)leaseTime, (Object)0L) * 1000L;
    }

    @Override
    @JsonGetter(value="expires_in")
    public long getExpiresIn() {
        return this.getExpiresAt().getTime() - this.now().getTime();
    }

    @Override
    @JsonGetter(value="is_expired")
    public boolean isExpired() {
        return this.getExpiresIn() <= 0L;
    }

    @Override
    @JsonGetter(value="expires_at")
    public Timestamp getExpiresAt() {
        return new Timestamp(this.createdAt.getTime() + this.leaseTime);
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public String getTokenType() {
        return this.tokenType;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public long getLeaseTime() {
        return this.leaseTime;
    }

    @Override
    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public String toString() {
        return "OauthAccessTokenResponse(accessToken=" + this.getAccessToken() + ", refreshToken=" + this.getRefreshToken() + ", tokenType=" + this.getTokenType() + ", scope=" + this.getScope() + ", leaseTime=" + this.getLeaseTime() + ", createdAt=" + this.getCreatedAt() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OauthAccessTokenResponse)) {
            return false;
        }
        OauthAccessTokenResponse other = (OauthAccessTokenResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLeaseTime() != other.getLeaseTime()) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        String this$tokenType = this.getTokenType();
        String other$tokenType = other.getTokenType();
        if (this$tokenType == null ? other$tokenType != null : !this$tokenType.equals(other$tokenType)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        Timestamp this$createdAt = this.getCreatedAt();
        Timestamp other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OauthAccessTokenResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $leaseTime = this.getLeaseTime();
        result = result * 59 + (int)($leaseTime >>> 32 ^ $leaseTime);
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        String $tokenType = this.getTokenType();
        result = result * 59 + ($tokenType == null ? 43 : $tokenType.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        Timestamp $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }
}

