/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.overrides;

import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.overrides.ParamsBuilder;
import com.xtm.aem.rest.overrides.model.ProjectTargetLanguageV2;
import com.xtm.aem.rest.overrides.model.ProjectTranslationFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class ParamsUtils {
    private ParamsUtils() {
        throw new UnsupportedOperationException("Non-instantiable");
    }

    public static Map<String, String> getDefaultHeaders(@Nonnull String authorization, @Nonnull ApiClient apiClient) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", apiClient.parameterToString(authorization));
        return Collections.unmodifiableMap(headers);
    }

    public static void ensureParameterIsSet(Object value, String parameter, String methodName) throws ApiException {
        if (value == null) {
            throw new ApiException(400, "Missing the required parameter '" + parameter + "' when calling " + methodName);
        }
    }

    @Nonnull
    public static Map<String, Object> populateTranslationFiles(List<ProjectTranslationFile> translationFiles, String fieldName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (translationFiles != null) {
            int translationFilesCounter = 0;
            for (ProjectTranslationFile translationFile : translationFiles) {
                String prefix = fieldName + "[" + translationFilesCounter + "].";
                params.putAll(ParamsUtils.populateTranslationFile(translationFile, prefix));
                ++translationFilesCounter;
            }
        }
        return Collections.unmodifiableMap(params);
    }

    @Nonnull
    public static Map<String, Object> populateTranslationFile(@Nonnull ProjectTranslationFile translationFile, String prefix) {
        prefix = StringUtils.defaultString((String)prefix, (String)"");
        Map<String, Object> baseParams = new ParamsBuilder().addIfNotEmpty(prefix + "file", translationFile.getFile()).addIfNotEmpty(prefix + "metadata", translationFile.getMetadata()).addIfNotEmpty(prefix + "metadataType", translationFile.getMetadataType()).addIfNotEmpty(prefix + "name", translationFile.getName()).addIfNotEmpty(prefix + "tagIds", translationFile.getTagIds()).addIfNotEmpty(prefix + "targetLanguages", translationFile.getTargetLanguages()).addIfNotEmpty(prefix + "translationType", translationFile.getTranslationType()).addIfNotEmpty(prefix + "workflowId", translationFile.getWorkflowId()).build();
        HashMap<String, Object> params = new HashMap<String, Object>(baseParams);
        if (translationFile.getTargetLanguagesV2() != null) {
            int targetLanguagesV2Counter = 0;
            for (ProjectTargetLanguageV2 lang : translationFile.getTargetLanguagesV2()) {
                String subPrefix = prefix + "targetLanguagesV2[" + targetLanguagesV2Counter + "].";
                Map<String, Object> langMap = new ParamsBuilder().addIfNotEmpty(subPrefix + "code", lang.getCode()).addIfNotEmpty(subPrefix + "workflowId", lang.getWorkflowId()).build();
                params.putAll(langMap);
                ++targetLanguagesV2Counter;
            }
        }
        return Collections.unmodifiableMap(params);
    }
}

