/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.services;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestClientFactory;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.ServerConfiguration;
import com.xtm.aem.rest.openapi.ServerVariable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.http.osgi.services.ProxyConfiguration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
public class XtmRestClientFactory
implements RestClientFactory {
    private static final Logger log = LoggerFactory.getLogger(XtmRestClientFactory.class);
    @Reference
    private HttpClientBuilderFactory httpClientBuilderFactory;

    @Override
    public ApiClient create(TranslationCloudConfig cloudConfig) throws ApiException {
        HttpClientBuilder builder = this.httpClientBuilderFactory.newBuilder();
        XtmRestClientFactory.setProxyConfiguration(cloudConfig.getProxyConfiguration(), builder);
        ApiClient apiClient = new ApiClient(builder.build());
        String baseUrl = XtmRestClientFactory.getRestBasePath(cloudConfig.getWebserviceUri());
        ArrayList<ServerConfiguration> servers = new ArrayList<ServerConfiguration>();
        servers.add(new ServerConfiguration(baseUrl + "/rest-api", "Main REST Endpoint", new HashMap<String, ServerVariable>()));
        servers.add(new ServerConfiguration(baseUrl + "/authentication-api", "Authentication REST Endpoint", new HashMap<String, ServerVariable>()));
        apiClient.setServers(servers);
        return apiClient;
    }

    private static String getRestBasePath(String soapWebServiceUrl) throws ApiException {
        try {
            URL url = new URL(soapWebServiceUrl);
            return url.getProtocol() + "://" + url.getHost();
        }
        catch (MalformedURLException e) {
            log.error("Invalid WS URL {}", (Object)soapWebServiceUrl, (Object)e);
            throw new ApiException("Invalid WS URL: " + soapWebServiceUrl);
        }
    }

    private static void setProxyConfiguration(ProxyConfiguration proxyConf, HttpClientBuilder builder) {
        if (proxyConf != null && proxyConf.isEnabled()) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            AuthScope authScope = new AuthScope(proxyConf.getHostname(), proxyConf.getPort());
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyConf.getUsername(), proxyConf.getPassword());
            credentialsProvider.setCredentials(authScope, (Credentials)credentials);
            HttpHost proxyHost = new HttpHost(proxyConf.getHostname(), proxyConf.getPort());
            builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            builder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxyHost));
            builder.setProxy(proxyHost);
        }
    }
}

