/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.services;

import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestActionFactory;
import com.xtm.aem.api.rest.RestConnectionStatus;
import com.xtm.aem.api.rest.RestConnectionStatusService;
import com.xtm.aem.api.rest.RestTokenStore;
import com.xtm.aem.rest.openapi.model.RSSystemInfoResponse;
import com.xtm.aem.rest.services.XtmRestConnectionStatus;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class XtmRestConnectionStatusService
implements RestConnectionStatusService {
    private static final Logger log = LoggerFactory.getLogger(XtmRestConnectionStatusService.class);
    static final String FAILED_TO_CONNECT_MSG = "Failed to connect to XTM system information endpoint. Please check logs for more details.";
    static final String CONNECTION_SUCCESSFUL_MSG = "Connection successful for XTM Translation Cloud Configuration";
    @Reference
    private RestActionFactory restActionFactory;
    @Reference
    private RestTokenStore tokenStore;

    @Override
    public RestConnectionStatus getConnectionStatus(@NotNull TranslationCloudConfig cloudConfig) {
        XtmRestConnectionStatus connectionStatus = null;
        try {
            RSSystemInfoResponse result = this.restActionFactory.getXtmSystemInfoAction(cloudConfig).run();
            connectionStatus = new XtmRestConnectionStatus(CONNECTION_SUCCESSFUL_MSG, cloudConfig.getPath(), result, this.tokenStore.getTokenResponse(cloudConfig));
        }
        catch (TranslationException e) {
            log.error(FAILED_TO_CONNECT_MSG, (Throwable)e);
            connectionStatus = new XtmRestConnectionStatus(FAILED_TO_CONNECT_MSG, cloudConfig.getPath(), null, this.tokenStore.getTokenResponse(cloudConfig));
        }
        return connectionStatus;
    }
}

