/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.postprocessors;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.xtm.aem.api.AuthorInstance;
import java.util.List;
import java.util.Objects;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.ModificationType;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class XtmEncryptionPostProcessor
implements SlingPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(XtmEncryptionPostProcessor.class);
    @Reference
    private CryptoSupport cryptoSupport;

    public void process(SlingHttpServletRequest request, List<Modification> changes) {
        if (!this.canProcess(request)) {
            return;
        }
        Session session = (Session)Objects.requireNonNull(request.getResourceResolver().adaptTo(Session.class));
        changes.stream().filter(m -> m.getType().equals((Object)ModificationType.MODIFY)).filter(m -> m.getSource().endsWith("/xtmPassword")).forEach(m -> this.handleModify((Modification)m, session));
    }

    private boolean canProcess(SlingHttpServletRequest request) {
        return request.getRequestPathInfo().getResourcePath().startsWith("/conf") && request.getResource().getResourceType().equals("cq/translation/components/mt-cloudconfig");
    }

    private void handleModify(Modification modification, Session session) {
        try {
            Property property = session.getProperty(modification.getSource());
            this.encryptProperty(property);
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Failed to read/write property", e);
        }
    }

    private void encryptProperty(Property property) throws RepositoryException {
        String propVal = property.getString();
        if (!this.cryptoSupport.isProtected(propVal)) {
            try {
                property.setValue(this.cryptoSupport.protect(propVal));
            }
            catch (CryptoException e) {
                log.error("Error on protecting property value", (Throwable)e);
            }
        }
    }
}

