/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.raw;

import com.day.cq.contentsync.handler.util.RequestResponseFactory;
import com.google.common.collect.ImmutableMap;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.raw.RawGuiInteractions;
import com.xtm.aem.api.raw.RawTranslationJob;
import com.xtm.aem.api.raw.RawTranslationProject;
import com.xtm.aem.services.shared.requests.FakeRequestWrapper;
import com.xtm.aem.services.shared.requests.FakeResponseWrapper;
import com.xtm.aem.services.shared.requests.SlingHttpServletRequestDecorator;
import com.xtm.aem.services.shared.requests.SlingHttpServletResponseDecorator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
public class RawAemGuiInteractions
implements RawGuiInteractions {
    @Reference(target="(component.name=com.adobe.cq.wcm.translation.impl.servlet.TranslationJobServlet)")
    private Servlet translationJobServlet;
    @Reference
    private RequestResponseFactory requestResponseFactory;

    @Override
    public int requestScope(RawTranslationJob job, ResourceResolver resourceResolver) {
        ImmutableMap params = ImmutableMap.of((Object)":operation", (Object)"SCOPE_REQUESTED", (Object)":translationJobPath", (Object)job.getPath());
        return this.sendPostRequest(resourceResolver.resolve(job.getPath()), (Map<String, Object>)params).getStatus();
    }

    @Override
    public int start(RawTranslationJob job, ResourceResolver resourceResolver) {
        ImmutableMap params = ImmutableMap.of((Object)":operation", (Object)"START_TRANSLATION", (Object)":translationJobPath", (Object)job.getPath());
        return this.sendPostRequest(resourceResolver.resolve(job.getPath()), (Map<String, Object>)params).getStatus();
    }

    @Override
    public int cancel(RawTranslationJob job, ResourceResolver resourceResolver) {
        ImmutableMap params = ImmutableMap.of((Object)":operation", (Object)"deleteLink", (Object)":translationJobPath", (Object)job.getPath());
        return this.sendPostRequest(resourceResolver.resolve(job.getPath()), (Map<String, Object>)params).getStatus();
    }

    @Override
    public int start(RawTranslationProject project, ResourceResolver resourceResolver) {
        ImmutableMap params = ImmutableMap.of((Object)"paths", (Object)project.getPath(), (Object)"operation", (Object)"startTranslation");
        return this.sendPostRequest(resourceResolver.resolve("/libs/cq/gui/components/projects/admin/translation"), (Map<String, Object>)params).getStatus();
    }

    private SlingHttpServletResponse sendGetRequest(Resource resource, Map<String, Object> params) {
        return this.sendRequest(resource, "GET", params);
    }

    private SlingHttpServletResponse sendPostRequest(Resource resource, Map<String, Object> params) {
        return this.sendRequest(resource, "POST", params);
    }

    private SlingHttpServletResponse sendRequest(Resource resource, String method, Map<String, Object> params) {
        SlingHttpServletRequestDecorator request = new SlingHttpServletRequestDecorator((HttpServletRequest)new FakeRequestWrapper(this.requestResponseFactory.createRequest(method, resource.getPath(), params)), resource);
        SlingHttpServletResponseDecorator response = new SlingHttpServletResponseDecorator((HttpServletResponse)new FakeResponseWrapper(this.requestResponseFactory.createResponse((OutputStream)new ByteArrayOutputStream())));
        try {
            this.translationJobServlet.service((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException | ServletException e) {
            response.setStatus(500);
        }
        return response;
    }
}

