/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview;

import com.google.common.collect.Lists;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.services.preview.PreviewConfig;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.ObjectUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PreviewConfig.class}, property={"service.description=Allows to define additional configurations for XTM preview", "label=XTM Preview configuration"}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
@Designate(ocd=Configuration.class)
public class XtmPreviewConfig
implements PreviewConfig {
    private static final Logger log = LoggerFactory.getLogger(XtmPreviewConfig.class);
    private final List<Pattern> referencesFilters = Lists.newArrayList();

    @Activate
    public void activate(Configuration configuration) {
        String[] referencesFiltersStrings;
        for (String regexString : referencesFiltersStrings = (String[])ObjectUtils.defaultIfNull((Object)configuration.references_filters(), (Object)new String[0])) {
            try {
                Pattern pattern = Pattern.compile(regexString);
                this.referencesFilters.add(pattern);
                if (!log.isDebugEnabled()) continue;
                log.debug("Registering new references filter pattern: '{}'", (Object)regexString);
            }
            catch (PatternSyntaxException e) {
                log.warn("Invalid pattern provided: '{}'", (Object)regexString, (Object)e);
            }
        }
    }

    @Override
    public List<Pattern> getReferencesFilters() {
        return this.referencesFilters;
    }

    @ObjectClassDefinition(name="XTM Preview Configuration", description="Allows to define additional configurations for XTM preview")
    public static @interface Configuration {
        @AttributeDefinition(name="References filters", description="Allows to filter out unwanted references to files related to page that we are generating preview for. Valid regular expressions are allowed.")
        public String[] references_filters();
    }
}

