/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.servlets;

import com.adobe.granite.translation.api.TranslationConfig;
import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.EmptyDataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.google.common.collect.ImmutableMap;
import com.xtm.aem.api.AuthorInstance;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.vendor=XTM Intl", "sling.servlet.methods=GET", "sling.servlet.resourceTypes=xtm/ui/xtm-translation-project/languages/source", "sling.servlet.resourceTypes=xtm/ui/xtm-translation-project/languages/target"}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class TranslationLanguageDataSourceServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(TranslationLanguageDataSourceServlet.class);
    private static final String RT_SOURCE = "xtm/ui/xtm-translation-project/languages/source";
    private static final ResourceMetadata blankMetadata = new ResourceMetadata();
    @Reference
    private TranslationConfig translationConfig;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        request.setAttribute(DataSource.class.getName(), (Object)EmptyDataSource.instance());
        try {
            List<Resource> options = this.prepareOptions(this.translationConfig.getLanguages(), request);
            options.sort(Comparator.comparing(r -> (String)r.getValueMap().get("text", String.class), this::compare));
            SimpleDataSource dataSource = new SimpleDataSource(options.iterator());
            request.setAttribute(DataSource.class.getName(), (Object)dataSource);
        }
        catch (TranslationException e) {
            log.error("Error attempting to get page details.", (Throwable)e);
        }
    }

    private int compare(String s1, String s2) {
        return StringUtils.substringBeforeLast((String)s1, (String)"(").compareTo(StringUtils.substringBeforeLast((String)s2, (String)"("));
    }

    private List<Resource> prepareOptions(Map<String, String> languageMap, SlingHttpServletRequest request) {
        LinkedList<Resource> options = new LinkedList<Resource>();
        String selectedKey = this.getSelectedKey(request);
        I18n i18n = new I18n((HttpServletRequest)request);
        ResourceResolver resourceResolver = request.getResourceResolver();
        for (String key : languageMap.keySet()) {
            String notTranslatedLabel = languageMap.get(key);
            String translatedLabel = StringUtils.isEmpty((CharSequence)notTranslatedLabel) ? key : i18n.getVar(notTranslatedLabel) + " (" + key + ")";
            ValueMap optionValueMap = this.createEntryValueMap(key, translatedLabel, selectedKey.equals(key));
            ValueMapResource optionResource = new ValueMapResource(resourceResolver, blankMetadata, "nt:unstructured", optionValueMap);
            options.add((Resource)optionResource);
        }
        return options;
    }

    private String getSelectedKey(SlingHttpServletRequest request) {
        String selectedKey;
        if (request.getResource().isResourceType(RT_SOURCE)) {
            String path = request.getParameter("item");
            selectedKey = Optional.of(request).map(SlingHttpServletRequest::getResourceResolver).map(rr -> (PageManager)rr.adaptTo(PageManager.class)).map(pm -> pm.getPage(path)).map(Page::getLanguage).map(Locale::getLanguage).orElse("");
        } else {
            selectedKey = "";
        }
        return selectedKey;
    }

    private ValueMap createEntryValueMap(String key, String label, boolean selected) {
        return new ValueMapDecorator((Map)ImmutableMap.of((Object)"text", (Object)label, (Object)"value", (Object)key, (Object)"selected", (Object)selected));
    }
}

