/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.servlets;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.models.xtm.debug.Project;
import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=GET", "sling.servlet.resourceTypes=cq/gui/components/projects/admin/card/projectcard", "sling.servlet.selectors=xtmdebug", "sling.servlet.extensions=json"}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class XtmTranslationProjectDebugServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(XtmTranslationProjectDebugServlet.class);
    static final String XTM_FORCE_DOWNLOAD_SELECTOR = "xtmdownload";
    private final ObjectMapper MAPPER = new ObjectMapper();

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        Resource projectResource = request.getResource().getChild("jcr:content");
        String translationProvider = (String)projectResource.getValueMap().get("translationProvider", String.class);
        if ("xtm-connector".equals(translationProvider)) {
            Project project = (Project)projectResource.adaptTo(Project.class);
            if (this.shouldDownload(request)) {
                response.setHeader("Content-Disposition", "attachment");
            }
            response.setStatus(200);
            response.getWriter().write(this.MAPPER.writeValueAsString((Object)project));
        } else {
            log.warn("Translation provider for this project '{}' is not a required {}", (Object)projectResource.getPath(), (Object)"xtm-connector");
            response.sendError(400, "Translation provider for this project is not a required xtm-connector");
        }
    }

    private boolean shouldDownload(SlingHttpServletRequest request) {
        return ArrayUtils.contains((Object[])request.getRequestPathInfo().getSelectors(), (Object)XTM_FORCE_DOWNLOAD_SELECTOR);
    }
}

