/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl.servlets;

import com.adobe.granite.crypto.CryptoSupport;
import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.config.http.ProxyConfigurationProvider;
import com.xtm.aem.api.rest.RestActionFactory;
import com.xtm.aem.api.rest.RestTokenManager;
import com.xtm.aem.rest.openapi.model.RSProjectTemplateResponse;
import com.xtm.translation.connector.xtmforaem.core.impl.servlets.AbstractDropdownListServlet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"service.vendor=Xtm Intl", "service.description=Lists project templates in the context of XTM user", "sling.servlet.methods=POST", "sling.servlet.paths=/services/xtm/projectTemplateList", "sling.servlet.extensions=json"}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
public class ProjectTemplateListServlet
extends AbstractDropdownListServlet<RSProjectTemplateResponse> {
    @Reference
    private RestActionFactory restActionFactory;
    @Reference
    private RestTokenManager restTokenManager;
    @Reference
    private ProxyConfigurationProvider proxyConfigurationProvider;
    @Reference
    private CryptoSupport cryptoSupport;

    @Override
    protected List<RSProjectTemplateResponse> getData(SlingHttpServletRequest request, TranslationCloudConfig cloudConfiguration) throws TranslationException {
        Long customerId = Optional.ofNullable(request.getParameter("customerId")).map(Long::parseLong).orElseThrow(() -> new TranslationException("customerId has not been provided", TranslationException.ErrorCode.MISSING_PARAMETER));
        return this.restActionFactory.getProjectTemplateList(customerId, cloudConfiguration).run();
    }

    @Override
    protected Map<String, Object> toDropdownListEntry(RSProjectTemplateResponse r) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", r.getId());
        map.put("name", r.getName());
        return map;
    }

    @Override
    public RestTokenManager getRestTokenManager() {
        return this.restTokenManager;
    }

    @Override
    public ProxyConfigurationProvider getProxyConfigurationProvider() {
        return this.proxyConfigurationProvider;
    }

    @Override
    public CryptoSupport getCryptoSupport() {
        return this.cryptoSupport;
    }
}

