/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.models.xtm.debug;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.config.TranslationCloudConfigFinder;
import com.xtm.aem.api.shared.ResourceResolverProvider;
import com.xtm.aem.models.xtm.debug.TranslationIntegrationConfig;
import com.xtm.aem.models.xtm.debug.TranslationJob;
import com.xtm.aem.models.xtm.debug.XtmCloudConfig;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class Project {
    private static final Logger log = LoggerFactory.getLogger(Project.class);
    private static final String FIND_TRANSLATION_CONFIGURATION_CC = "SELECT * FROM [nt:base] AS r WHERE ISDESCENDANTNODE([%s]) AND r.[sling:resourceType] = 'cq/translation/components/mt-cloudconfig'AND r.[cq:template] = '/libs/cq/translation/templates/mt-servicepage'";
    @JsonIgnore
    @OSGiService
    private TranslationCloudConfigFinder configFinder;
    @JsonIgnore
    @OSGiService
    private ResourceResolverProvider resourceResolverProvider;
    @JsonIgnore
    @Self
    private transient Resource resource;
    @ValueMapValue
    private boolean active;
    @ValueMapValue(name="cq:conf")
    private String cqConf;
    @ValueMapValue(name="jcr:title")
    private String title;
    @ValueMapValue(name="project.startDate")
    private Date startDate;
    @ValueMapValue
    private String sourceLanguage;
    @ValueMapValue
    private String translationAutomaticApproveEnable;
    @ValueMapValue
    private String translationAutomaticDeleteLaunchEnable;
    @ValueMapValue
    private String translationAutomaticPromoteLaunchEnable;
    @ValueMapValue
    private String translationCloudConfigPath;
    @ValueMapValue
    private String translationProvider;
    @ValueMapValue
    private String translationSchedulerRepeatDay;
    @ValueMapValue
    private String translationSchedulerRepeatMonth;
    @ValueMapValue
    private String translationSchedulerRepeatStartTime;
    @ValueMapValue
    private String translationSchedulerRepeatType;
    @ValueMapValue
    private String translationSchedulerRepeatWeek;
    @ValueMapValue
    private String translationSchedulerRepeatWeekDay;
    private List<TranslationJob> translationJobs;
    private XtmCloudConfig xtmCloudConfig;
    private TranslationIntegrationConfig translationIntegrationConfig;

    @PostConstruct
    protected void postConstruct() {
        try (ResourceResolver rr = this.resourceResolverProvider.getXtmResourceResolver();){
            this.translationJobs = this.constructTranslationGadgets().stream().map(r -> (TranslationJob)r.adaptTo(TranslationJob.class)).collect(Collectors.toList());
            TranslationCloudConfig config = this.configFinder.getConfig(this.cqConf, rr);
            if (config != null) {
                this.xtmCloudConfig = this.constructXtmCloudConfig(config.getPath());
            }
            this.translationIntegrationConfig = this.constructTranslationIntegrationConfig(rr);
        }
        catch (LoginException e) {
            log.error("Faile to obtain resource resolver", (Throwable)e);
        }
    }

    private TranslationIntegrationConfig constructTranslationIntegrationConfig(ResourceResolver rr) {
        String query = String.format(FIND_TRANSLATION_CONFIGURATION_CC, this.cqConf);
        Iterator resources = rr.findResources(query, "JCR-SQL2");
        if (resources.hasNext()) {
            return Optional.of((Resource)resources.next()).map(r -> (TranslationIntegrationConfig)r.adaptTo(TranslationIntegrationConfig.class)).orElse(null);
        }
        return null;
    }

    private XtmCloudConfig constructXtmCloudConfig(String cloudConfigPath) {
        return Optional.of(this.resource).map(Resource::getResourceResolver).map(rr -> rr.getResource(cloudConfigPath + "/jcr:content")).map(r -> (XtmCloudConfig)r.adaptTo(XtmCloudConfig.class)).orElse(null);
    }

    private List<Resource> constructTranslationGadgets() {
        return Optional.of(this.resource).map(r -> r.getChild("dashboard")).map(r -> r.getChild("gadgets")).map(Resource::getChildren).map(Iterable::spliterator).map(s -> StreamSupport.stream(s, false)).map(s -> s.filter(r -> "cq/gui/components/projects/admin/pod/translationjobpod".equals(r.getResourceType()))).map(s -> s.collect(Collectors.toList())).orElse(Lists.newArrayList());
    }

    public TranslationCloudConfigFinder getConfigFinder() {
        return this.configFinder;
    }

    public ResourceResolverProvider getResourceResolverProvider() {
        return this.resourceResolverProvider;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getCqConf() {
        return this.cqConf;
    }

    public String getTitle() {
        return this.title;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public String getTranslationAutomaticApproveEnable() {
        return this.translationAutomaticApproveEnable;
    }

    public String getTranslationAutomaticDeleteLaunchEnable() {
        return this.translationAutomaticDeleteLaunchEnable;
    }

    public String getTranslationAutomaticPromoteLaunchEnable() {
        return this.translationAutomaticPromoteLaunchEnable;
    }

    public String getTranslationCloudConfigPath() {
        return this.translationCloudConfigPath;
    }

    public String getTranslationProvider() {
        return this.translationProvider;
    }

    public String getTranslationSchedulerRepeatDay() {
        return this.translationSchedulerRepeatDay;
    }

    public String getTranslationSchedulerRepeatMonth() {
        return this.translationSchedulerRepeatMonth;
    }

    public String getTranslationSchedulerRepeatStartTime() {
        return this.translationSchedulerRepeatStartTime;
    }

    public String getTranslationSchedulerRepeatType() {
        return this.translationSchedulerRepeatType;
    }

    public String getTranslationSchedulerRepeatWeek() {
        return this.translationSchedulerRepeatWeek;
    }

    public String getTranslationSchedulerRepeatWeekDay() {
        return this.translationSchedulerRepeatWeekDay;
    }

    public List<TranslationJob> getTranslationJobs() {
        return this.translationJobs;
    }

    public XtmCloudConfig getXtmCloudConfig() {
        return this.xtmCloudConfig;
    }

    public TranslationIntegrationConfig getTranslationIntegrationConfig() {
        return this.translationIntegrationConfig;
    }
}

