/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestActionFactory;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.rest.actions.BaseXtmRestAction;
import com.xtm.aem.rest.actions.XtmRestActionsUtil;
import com.xtm.aem.rest.openapi.api.ProjectsApi;
import com.xtm.aem.rest.openapi.model.RSProjectCreationResponse;
import com.xtm.aem.rest.openapi.model.RSProjectUpdateRequest;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateProjectRestAction
extends BaseXtmRestAction<RSProjectCreationResponse> {
    private static final Logger log = LoggerFactory.getLogger(CreateProjectRestAction.class);
    private final AemTranslationJob translationJob;
    private final RestActionFactory actionFactory;

    protected CreateProjectRestAction(AemTranslationJob atj, TranslationCloudConfig cloudConfig, RestServicesWrapper restServicesWrapper, RestActionFactory restActionFactory) {
        super(cloudConfig, restServicesWrapper);
        this.translationJob = atj;
        this.actionFactory = restActionFactory;
    }

    @Override
    protected RSProjectCreationResponse runInternal() throws Exception {
        log.trace("CreateProjectRestAction.runInternal");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        ProjectsApi projectsApi = new ProjectsApi(this.getApiClient());
        String accessToken = this.getAccessToken();
        RSProjectCreationResponse projectCreationResponse = projectsApi.createProjectUsingPOST(accessToken, this.translationJob.getXtmProjectName(), this.translationJob.getDescription(), Optional.ofNullable(this.translationJob.getDueDate()).map(dateFormat::format).orElse(null), this.cloudConfig.getUserId(), this.cloudConfig.getCustomerId(), this.cloudConfig.getTemplateId(), this.getLanguageFromMapping(this.translationJob.getSourceLanguage()), Collections.singletonList(this.getLanguageFromMapping(this.translationJob.getTargetLanguage())), XtmRestActionsUtil.prepareTranslationFiles(this.translationJob.getAemTranslationObjects()), this.cloudConfig.getAnalysisFinishedCallback(), this.cloudConfig.getJobFinishedCallback(), this.cloudConfig.getProjectFinishedCallback(), this.cloudConfig.getWorkflowTransitionCallback(), null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        if (!Objects.equals(this.cloudConfig.getUserId(), this.cloudConfig.getProjectManagerId())) {
            this.actionFactory.getProjectAnalysisCompletionAction(projectCreationResponse.getProjectId(), this.cloudConfig).run();
            RSProjectUpdateRequest update = new RSProjectUpdateRequest();
            update.setProjectManagerId(this.cloudConfig.getProjectManagerId());
            projectsApi.updateProjectUsingPUT(accessToken, projectCreationResponse.getProjectId(), update, null);
        }
        return projectCreationResponse;
    }

    private String getLanguageFromMapping(String aemLang) throws XtmConnectorException {
        String xtmLanguage = this.cloudConfig.getLanguageMapping().get(aemLang);
        if (xtmLanguage == null) {
            throw new XtmConnectorException("Failed to map given AEM lang '" + aemLang + "' to XTM lang");
        }
        return xtmLanguage;
    }
}

