/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.rest.actions.BaseXtmRestAction;
import com.xtm.aem.rest.openapi.api.ProjectStatesApi;
import com.xtm.aem.rest.openapi.model.RSProjectStatusResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObtainProjectStatusRestAction
extends BaseXtmRestAction<RSProjectStatusResponse> {
    private static final Logger log = LoggerFactory.getLogger(ObtainProjectStatusRestAction.class);
    private final Long projectId;

    protected ObtainProjectStatusRestAction(Long projectId, TranslationCloudConfig cloudConfig, RestServicesWrapper restServicesWrapper) {
        super(cloudConfig, restServicesWrapper);
        this.projectId = projectId;
    }

    @Override
    protected RSProjectStatusResponse runInternal() throws Exception {
        log.trace("ObtainProjectStatusRestAction.obtainEstimates");
        log.debug("Obtaining project status for ID: {}", (Object)this.projectId);
        ProjectStatesApi projectStatesApi = new ProjectStatesApi(this.getApiClient());
        return projectStatesApi.checkProjectStatusesUsingGET(this.getAccessToken(), this.projectId, "JOBS", null, null, null);
    }
}

