/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.xtm.aem.api.XtmAction;
import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.rest.actions.BaseXtmRestAction;
import com.xtm.aem.rest.openapi.api.ProjectActivityApi;
import com.xtm.aem.rest.openapi.model.RSActivateProjectResponse;
import com.xtm.aem.rest.openapi.model.RSProjectStatusResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectActivateRestAction
extends BaseXtmRestAction<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(ProjectActivateRestAction.class);
    private final Long projectId;
    private final XtmAction<RSProjectStatusResponse> obtainProjectStatusAction;
    private final int analysisCheckMaxRetries;
    private final int analysisCheckRetryInterval;

    protected ProjectActivateRestAction(Long projectId, TranslationCloudConfig cloudConfig, RestServicesWrapper restServicesWrapper, XtmAction<RSProjectStatusResponse> obtainProjectStatusAction) {
        super(cloudConfig, restServicesWrapper);
        this.projectId = projectId;
        this.obtainProjectStatusAction = obtainProjectStatusAction;
        this.analysisCheckMaxRetries = cloudConfig.getAnalysisCheckMaxRetries();
        this.analysisCheckRetryInterval = cloudConfig.getAnalysisCheckRetryInterval();
    }

    @Override
    protected Boolean runInternal() throws Exception {
        log.trace("ProjectActivateRestAction.runInternal");
        ProjectActivityApi projectActivityApi = new ProjectActivityApi(this.getApiClient());
        RSActivateProjectResponse response = projectActivityApi.activateProjectUsingPOST(this.getAccessToken(), this.projectId);
        if (Boolean.TRUE.equals(response.getSuccess())) {
            for (int i = 0; i < this.analysisCheckMaxRetries; ++i) {
                RSProjectStatusResponse statusResponse = this.obtainProjectStatusAction.run();
                if (RSProjectStatusResponse.ActivityEnum.ACTIVE.equals((Object)statusResponse.getActivity())) {
                    return true;
                }
                if (RSProjectStatusResponse.ActivityEnum.ARCHIVED.equals((Object)statusResponse.getActivity()) || RSProjectStatusResponse.ActivityEnum.AUTO_ARCHIVED.equals((Object)statusResponse.getActivity())) {
                    log.warn("Failed to re-activate project '{}'. It appears that it has been permanently moved to deep archive.", (Object)this.projectId);
                    return false;
                }
                Thread.sleep(this.analysisCheckRetryInterval);
            }
            throw new XtmConnectorException("Maximum number of retries exceeded while checking for project activation completion in XTM");
        }
        log.error("Failed to re-activate project '{}' ", (Object)this.projectId);
        return false;
    }
}

