/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestConnectionStatus;
import com.xtm.aem.api.rest.RestConnectionStatusService;
import com.xtm.aem.models.config.TranslationCloudConfigUtil;
import com.xtm.aem.rest.services.XtmRestConnectionStatus;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.vendor=Xtm Intl", "sling.servlet.methods=GET", "sling.servlet.paths=/services/xtm/rest-connection-test"})
public class XtmRestConnectionStatusServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(XtmRestConnectionStatusServlet.class);
    static final String SERVLET_PATH = "/services/xtm/rest-connection-test";
    static final String CONFIGURATION_PATH_PARAM = "configurationPath";
    static final String INVALID_QUERY_PARAMETER_MSG = "Please specify configurationPath query parameter that points to a valid XTM configuration.";
    static final String FAILED_TO_OBTAIN_CC_MSG = "Failed to obtain XTM Translation Cloud Configuration";
    static final String FAILED_TO_VALIDATE_CC = "Provided cloud configuration is invalid. Please ensure that required fields are set.";
    @Reference
    private RestConnectionStatusService restConnectionStatusService;

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        String xtmConfPath = request.getParameter(CONFIGURATION_PATH_PARAM);
        if (StringUtils.isBlank((CharSequence)xtmConfPath)) {
            XtmRestConnectionStatusServlet.writeError(response, 404, INVALID_QUERY_PARAMETER_MSG, null);
            return;
        }
        TranslationCloudConfig cc = XtmRestConnectionStatusServlet.getTranslationCloudConfig(request, xtmConfPath);
        if (cc == null) {
            XtmRestConnectionStatusServlet.writeError(response, 404, FAILED_TO_OBTAIN_CC_MSG, xtmConfPath);
            return;
        }
        if (!TranslationCloudConfigUtil.isValid(cc)) {
            XtmRestConnectionStatusServlet.writeError(response, 401, FAILED_TO_VALIDATE_CC, xtmConfPath);
            return;
        }
        RestConnectionStatus connectionStatus = this.restConnectionStatusService.getConnectionStatus(cc);
        if (connectionStatus.isConnected()) {
            response.setStatus(200);
        } else {
            response.setStatus(400);
        }
        XtmRestConnectionStatusServlet.write(response, connectionStatus);
    }

    private static TranslationCloudConfig getTranslationCloudConfig(SlingHttpServletRequest request, String xtmConfPath) {
        return Optional.of(request).map(SlingHttpServletRequest::getResourceResolver).map(resourceResolver -> resourceResolver.getResource(xtmConfPath)).map(r -> (TranslationCloudConfig)r.adaptTo(TranslationCloudConfig.class)).orElse(null);
    }

    private static void writeError(SlingHttpServletResponse response, int httpStatusCode, String message, String xtmConfPath) throws IOException {
        response.setStatus(httpStatusCode);
        XtmRestConnectionStatus connectionStatus = new XtmRestConnectionStatus(message, xtmConfPath);
        log.error(String.valueOf(connectionStatus));
        XtmRestConnectionStatusServlet.write(response, connectionStatus);
    }

    private static void write(SlingHttpServletResponse response, RestConnectionStatus status) throws IOException {
        response.setContentType("application/json");
        response.getWriter().write(new ObjectMapper().writeValueAsString((Object)status));
    }
}

