/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.services;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.OauthAccessTokenModel;
import com.xtm.aem.api.rest.RestTokenStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class XtmRestTokenStore
implements RestTokenStore {
    public static final String BEARER_PREFIX = "Bearer ";
    private final Map<String, OauthAccessTokenModel> tokenMap = new HashMap<String, OauthAccessTokenModel>();

    @Override
    public void addToken(TranslationCloudConfig cloudConfig, OauthAccessTokenModel value) {
        Objects.requireNonNull(cloudConfig);
        Objects.requireNonNull(value);
        Objects.requireNonNull(value.getRefreshToken());
        Objects.requireNonNull(value.getAccessToken());
        this.tokenMap.put(XtmRestTokenStore.getKey(cloudConfig), value);
    }

    @Override
    public OauthAccessTokenModel getTokenResponse(TranslationCloudConfig cloudConfig) {
        return Optional.ofNullable(XtmRestTokenStore.getKey(cloudConfig)).map(this.tokenMap::get).orElse(null);
    }

    @Override
    public Map<String, OauthAccessTokenModel> getTokenResponses() {
        return this.tokenMap;
    }

    @Override
    public String getAccessToken(TranslationCloudConfig cloudConfig) {
        return Optional.ofNullable(this.getTokenResponse(cloudConfig)).map(OauthAccessTokenModel::getAccessToken).map(BEARER_PREFIX::concat).orElse(null);
    }

    @Override
    public String getRefreshToken(TranslationCloudConfig cloudConfig) {
        return Optional.ofNullable(this.getTokenResponse(cloudConfig)).map(OauthAccessTokenModel::getRefreshToken).map(BEARER_PREFIX::concat).orElse(null);
    }

    @Override
    public void clearTokens() {
        this.tokenMap.clear();
    }

    @Override
    public void clearToken(TranslationCloudConfig cloudConfig) {
        this.tokenMap.remove(XtmRestTokenStore.getKey(cloudConfig));
    }

    private static String getKey(TranslationCloudConfig cloudConfig) {
        return Optional.ofNullable(cloudConfig).map(cc -> cc.getClient() + ":" + cc.getUserId()).orElse(null);
    }
}

