/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.services.postprocessors;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestTokenManager;
import java.util.List;
import java.util.Optional;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class XtmCredentialsPostProcessor
implements SlingPostProcessor {
    @Reference
    private RestTokenManager restTokenManager;

    public void process(SlingHttpServletRequest request, List<Modification> list) {
        if (!XtmCredentialsPostProcessor.canProcess(request)) {
            return;
        }
        Optional.of(request).map(SlingHttpServletRequest::getResource).map(Resource::getParent).map(r -> (TranslationCloudConfig)r.adaptTo(TranslationCloudConfig.class)).ifPresent(cc -> this.restTokenManager.obtainOrRefreshToken((TranslationCloudConfig)cc));
    }

    private static boolean canProcess(SlingHttpServletRequest request) {
        return request.getRequestPathInfo().getResourcePath().startsWith("/conf") && request.getResource().getResourceType().equals("cq/translation/components/mt-cloudconfig");
    }
}

