/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.config;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.http.ProxyConfigurationOverride;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.description=Proxy override settings for the XTM Translation connector", "label=XTM Translation Connector Proxy Override"}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
@Designate(ocd=Configuration.class)
public class ProxyConfigurationOverrideService
implements ProxyConfigurationOverride {
    private String hostname;
    private int port;
    private String username;
    private String password;
    private boolean forceNoProxy;

    @Activate
    public void activate(Configuration configuration) {
        this.hostname = configuration.host_name();
        this.port = configuration.port();
        this.username = configuration.user_name();
        this.password = configuration.user_password();
        this.forceNoProxy = configuration.force_no_proxy();
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean isForceNoProxy() {
        return this.forceNoProxy;
    }

    @ObjectClassDefinition(name="XTM Translation Connector Proxy Override", description="XTM Translation Connector Proxy Override Configuration")
    public static @interface Configuration {
        @AttributeDefinition(name="Proxy hostname", description="The hostname of the proxy to be used for communicating with XTM")
        public String host_name();

        @AttributeDefinition(name="Proxy port", description="The port of the proxy to be used for communicating with XTM")
        public int port();

        @AttributeDefinition(name="Proxy username", description="The username of the proxy to be used for communicating with XTM")
        public String user_name();

        @AttributeDefinition(name="Proxy password", description="The password of the proxy to be used for communicating with XTM")
        public String user_password();

        @AttributeDefinition(name="Force no proxy", description="If checked, the connector will not use any proxy")
        public boolean force_no_proxy();
    }
}

