/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.raw;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.raw.RawResourceProvider;
import java.util.Iterator;
import java.util.Optional;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
@Designate(ocd=Configuration.class)
public class RawResourceProviderService
implements RawResourceProvider {
    private static final Logger log = LoggerFactory.getLogger(RawResourceProviderService.class);
    private static final int DEFAULT_SEARCH_RETRIES_AMOUNT = 20;
    private static final int DEFAULT_SEARCH_RETRIES_INTERVAL = 3000;
    private static final String FIND_TRANSLATION_JOB_BY_ID = "SELECT * FROM [nt:base] AS r WHERE ISDESCENDANTNODE([/content/projects]) AND r.[sling:resourceType] = 'cq/gui/components/projects/admin/pod/translationjobpod' AND r.[translationObjectID] = '%s'";
    private int indexCheckRetries;
    private int indexCheckInterval;

    @Activate
    public void activate(Configuration configuration) {
        this.indexCheckRetries = configuration.index_check_retries();
        this.indexCheckInterval = configuration.index_check_interval();
    }

    @Override
    public Optional<Resource> getTranslationJob(String aemTranslationJobId, ResourceResolver resourceResolver) throws IllegalStateException {
        Optional<Resource> translationJobResource = Optional.empty();
        log.debug("Searching for Translation Job with ID '{}', retries: '{}', interval '{}'", new Object[]{aemTranslationJobId, this.indexCheckRetries, this.indexCheckInterval});
        for (int i = 0; i < this.indexCheckRetries; ++i) {
            translationJobResource = this.findTranslationJob(aemTranslationJobId, resourceResolver);
            if (translationJobResource.isPresent()) {
                log.debug("TranslationJob with ID '{}' found. Attempt: {}", (Object)aemTranslationJobId, (Object)i);
                break;
            }
            try {
                Thread.sleep(this.indexCheckInterval);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Thread failed to sleep", e);
            }
            log.debug("TranslationJob with ID '{}' not found. Attempt: {}", (Object)aemTranslationJobId, (Object)i);
        }
        return translationJobResource;
    }

    private Optional<Resource> findTranslationJob(String aemTranslationJobId, ResourceResolver resourceResolver) throws IllegalStateException {
        String query = String.format(FIND_TRANSLATION_JOB_BY_ID, aemTranslationJobId);
        Iterator foundTranslationJobs = resourceResolver.findResources(query, "JCR-SQL2");
        if (!foundTranslationJobs.hasNext()) {
            log.debug("Could not find a project with ID '{}'", (Object)aemTranslationJobId);
            return Optional.empty();
        }
        Resource translationJobResource = (Resource)foundTranslationJobs.next();
        if (foundTranslationJobs.hasNext()) {
            throw new IllegalStateException("Found multiple translation jobs with id '" + aemTranslationJobId + "'");
        }
        return Optional.of(translationJobResource);
    }

    @ObjectClassDefinition(name="XTM RAW Resource Provider Service Configuration")
    public static @interface Configuration {
        @AttributeDefinition(type=AttributeType.INTEGER, name="Index Check Retries count", description="Maximum number of times we wait the index to be populated with new translationObjectId", defaultValue={"20"}, min="1")
        public int index_check_retries() default 20;

        @AttributeDefinition(type=AttributeType.INTEGER, name="Index Check Retries interval", description="Interval in millisecond between each index check", defaultValue={"3000"}, min="1")
        public int index_check_interval() default 3000;
    }
}

