/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview;

import com.google.common.collect.Lists;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.services.preview.PreviewConfig;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.ObjectUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PreviewConfig.class}, property={"service.description=Define additional configurations for XTM preview here", "label=XTM Preview configuration"}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
@Designate(ocd=Configuration.class)
public class XtmPreviewConfig
implements PreviewConfig {
    private static final Logger log = LoggerFactory.getLogger(XtmPreviewConfig.class);
    private final List<Pattern> referenceFilters = Lists.newArrayList();
    private final List<Pattern> customHtmlReferencePatterns = Lists.newArrayList();

    @Activate
    public void activate(Configuration configuration) {
        this.setupPatterns(configuration.reference_filters(), this.referenceFilters, "reference filters");
        this.setupPatterns(configuration.custom_html_reference_patterns(), this.customHtmlReferencePatterns, "custom HTML references patterns");
        if (configuration.references_filters() != null) {
            log.warn("DEPRECATED OSGi property in use. Please migrate references_filters -> reference_filters");
            this.setupPatterns(configuration.references_filters(), this.referenceFilters, "references filters");
        }
    }

    private void setupPatterns(String[] inputList, List<Pattern> targetList, String name) {
        String[] referencesFiltersStrings;
        for (String regexString : referencesFiltersStrings = (String[])ObjectUtils.defaultIfNull((Object)inputList, (Object)new String[0])) {
            try {
                Pattern pattern = Pattern.compile(regexString);
                targetList.add(pattern);
                if (!log.isDebugEnabled()) continue;
                log.debug("Registering new '{}' pattern: '{}'", (Object)name, (Object)regexString);
            }
            catch (PatternSyntaxException e) {
                log.warn("Invalid pattern provided: '{}'", (Object)regexString, (Object)e);
            }
        }
    }

    @Override
    public List<Pattern> getReferenceFilters() {
        return this.referenceFilters;
    }

    @Override
    public List<Pattern> getCustomHtmlReferencePatterns() {
        return this.customHtmlReferencePatterns;
    }

    @ObjectClassDefinition(name="XTM Preview Configuration", description="Define additional configurations for XTM preview here.")
    public static @interface Configuration {
        @AttributeDefinition(name="Reference filters", description="Enter reference filters (valid regular expressions) to filter out unwanted references to files that relate to the page for which a preview is to be generated.")
        public String[] reference_filters();

        @Deprecated
        @AttributeDefinition(name="References filters [DEPRECATED]", description="[DEPRECATED] replaced by Reference filters")
        public String[] references_filters();

        @AttributeDefinition(name="Custom HTML reference patterns", description="Enter additional, non-standard reference patterns (valid regular expressions) that should be included in the preview package.")
        public String[] custom_html_reference_patterns();
    }
}

