/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.google.common.collect.ImmutableList;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.services.preview.PreviewConfig;
import com.xtm.aem.api.services.preview.PreviewGenerator;
import com.xtm.aem.api.services.preview.PreviewItem;
import com.xtm.aem.api.services.preview.PreviewItemFactory;
import com.xtm.aem.api.services.preview.PreviewZipFile;
import com.xtm.aem.api.shared.ResourceResolverProvider;
import com.xtm.aem.models.zip.PreviewZipEntryModel;
import com.xtm.aem.models.zip.PreviewZipFileModel;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
public class XtmPreviewGenerator
implements PreviewGenerator {
    private static final Logger log = LoggerFactory.getLogger(XtmPreviewGenerator.class);
    @Reference
    private ResourceResolverProvider resolverProvider;
    @Reference
    private PreviewItemFactory previewItemFactory;
    @Reference
    private PreviewConfig previewConfig;

    @Override
    public PreviewZipFile getPreview(String pagePath) throws XtmConnectorException {
        return this.getPreview((Collection<String>)ImmutableList.of((Object)pagePath));
    }

    @Override
    public PreviewZipFile getPreview(String pagePath, ResourceResolver resourceResolver) {
        return this.getPreview((Collection<String>)ImmutableList.of((Object)pagePath), resourceResolver);
    }

    @Override
    public PreviewZipFile getPreview(Collection<String> pagePaths) throws XtmConnectorException {
        PreviewZipFile previewZipFile;
        block8: {
            ResourceResolver resourceResolver = this.resolverProvider.getTranslationPreviewResourceResolver();
            try {
                previewZipFile = this.getPreview(pagePaths, resourceResolver);
                if (resourceResolver == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceResolver != null) {
                        try {
                            resourceResolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LoginException e) {
                    throw new XtmConnectorException("Could not generate preview for pages '" + pagePaths + "'", e);
                }
            }
            resourceResolver.close();
        }
        return previewZipFile;
    }

    @Override
    public PreviewZipFile getPreview(Collection<String> pagePaths, ResourceResolver resourceResolver) {
        Collection<PreviewItem> previewItems = this.getPreviewItems(pagePaths, resourceResolver);
        return this.getAsPreviewZipFile(previewItems);
    }

    private Collection<PreviewItem> getPreviewItems(Collection<String> paths, ResourceResolver resourceResolver) {
        if (log.isDebugEnabled()) {
            log.debug("Assembling preview for the following items:\n {}", (Object)String.join((CharSequence)"\n", paths));
        }
        List<Pattern> filters = this.previewConfig.getReferenceFilters();
        LinkedList<PreviewItem> previewItems = new LinkedList<PreviewItem>();
        HashSet<String> refPaths = new HashSet<String>();
        Queue<String> refQueue = this.initializeQueue(paths, resourceResolver);
        while (!refQueue.isEmpty()) {
            String ref = refQueue.poll();
            if (!refPaths.add(ref)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Skipping '{}' - already included", (Object)ref);
                continue;
            }
            log.debug("Including '{}'", (Object)ref);
            PreviewItem item = this.previewItemFactory.getPreviewItem(ref, resourceResolver);
            previewItems.add(item);
            if (log.isDebugEnabled()) {
                log.debug("Pushing following references to queue: {}", (Object)String.join((CharSequence)",", item.getReferences()));
            }
            List filteredReferences = item.getReferences().stream().filter(itemRef -> this.filterItem(filters, (String)itemRef)).collect(Collectors.toList());
            refQueue.addAll(filteredReferences);
        }
        return previewItems;
    }

    private boolean filterItem(List<Pattern> filters, String ref) {
        return filters.stream().noneMatch(filter -> filter.matcher(ref).matches());
    }

    private Queue<String> initializeQueue(Collection<String> paths, ResourceResolver resourceResolver) {
        PageManager pageManager = Objects.requireNonNull((PageManager)resourceResolver.adaptTo(PageManager.class));
        return paths.stream().map(arg_0 -> ((PageManager)pageManager).getContainingPage(arg_0)).filter(Objects::nonNull).map(Page::getPath).map(path -> path + ".html").collect(Collectors.toCollection(LinkedList::new));
    }

    private PreviewZipFile getAsPreviewZipFile(Collection<PreviewItem> previewItems) {
        PreviewZipFileModel result = new PreviewZipFileModel();
        previewItems.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getPath())).map(item -> new PreviewZipEntryModel(item.getPath(), item.getBytes())).forEach(result::put);
        return result;
    }
}

