/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview;

import com.day.cq.contentsync.handler.util.RequestResponseFactory;
import com.day.cq.wcm.api.WCMMode;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.services.preview.PreviewConfig;
import com.xtm.aem.api.services.preview.PreviewGenerator;
import com.xtm.aem.api.services.preview.PreviewItem;
import com.xtm.aem.api.services.preview.PreviewItemFactory;
import com.xtm.aem.services.shared.requests.FakeRequestWrapper;
import com.xtm.aem.services.shared.requests.FakeResponseWrapper;
import com.xtm.aem.services.translation.preview.items.CssPreviewItem;
import com.xtm.aem.services.translation.preview.items.DefaultPreviewItem;
import com.xtm.aem.services.translation.preview.items.EmptyPreviewItem;
import com.xtm.aem.services.translation.preview.items.HtmlPreviewItem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.engine.SlingRequestProcessor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class XtmPreviewItemFactory
implements PreviewItemFactory {
    private static final Logger log = LoggerFactory.getLogger(XtmPreviewItemFactory.class);
    @Reference
    private SlingRequestProcessor requestProcessor;
    @Reference
    private RequestResponseFactory requestResponseFactory;
    @Reference
    private PreviewConfig previewConfig;

    @Override
    public PreviewItem getPreviewItem(String path, ResourceResolver resourceResolver) {
        String extension;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HttpServletResponse response = this.getResponse(baos);
        try {
            HttpServletRequest request = this.getRequest(path);
            this.requestProcessor.processRequest(request, response, resourceResolver);
        }
        catch (IOException | ServletException e) {
            log.error("Failed to obtain stream for file '{}'", (Object)path, (Object)e);
            return EmptyPreviewItem.INSTANCE;
        }
        if (response.getStatus() >= 400) {
            log.error("Failed to obtain stream for file '{}', with HTTP status: {}", (Object)path, (Object)response.getStatus());
            return EmptyPreviewItem.INSTANCE;
        }
        String characterEncoding = response.getCharacterEncoding();
        switch (extension = StringUtils.substringAfterLast((String)path, (String)".")) {
            case "html": {
                return new HtmlPreviewItem(path, baos, characterEncoding, this.previewConfig.getCustomHtmlReferencePatterns());
            }
            case "css": {
                return new CssPreviewItem(path, baos, characterEncoding);
            }
        }
        return new DefaultPreviewItem(path, baos, characterEncoding);
    }

    private HttpServletRequest getRequest(String pagePath) {
        try {
            pagePath = URLDecoder.decode(pagePath, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Failed to decode page path: " + pagePath, e);
        }
        HttpServletRequest fakeRequest = this.requestResponseFactory.createRequest("GET", pagePath);
        fakeRequest.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)WCMMode.DISABLED);
        FakeRequestWrapper request = new FakeRequestWrapper(fakeRequest);
        try {
            request.setCharacterEncoding(PreviewGenerator.CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("'" + PreviewGenerator.CHARACTER_ENCODING + "' encoding is unsupported", e);
        }
        return request;
    }

    private HttpServletResponse getResponse(ByteArrayOutputStream baos) {
        HttpServletResponse fakeResponse = this.requestResponseFactory.createResponse((OutputStream)baos);
        return new FakeResponseWrapper(fakeResponse);
    }
}

