/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview.items;

import com.xtm.aem.api.services.preview.PreviewItem;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BasePreviewItem
implements PreviewItem {
    private static final Logger log = LoggerFactory.getLogger(BasePreviewItem.class);
    protected final String path;
    protected final ByteArrayOutputStream baos;
    protected final String characterEncoding;
    protected final String rawContent;

    protected BasePreviewItem(String path, @NotNull ByteArrayOutputStream baos, String characterEncoding) {
        this.path = path;
        this.baos = baos;
        this.characterEncoding = characterEncoding;
        this.rawContent = this.getRawContent(path, baos);
    }

    private String getRawContent(String path, ByteArrayOutputStream baos) {
        if (StringUtils.isBlank((CharSequence)this.characterEncoding)) {
            return "";
        }
        try {
            return baos.toString(this.characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Could not get item '{}' as string", (Object)path, (Object)e);
            return "";
        }
    }

    @Override
    public String getContent() {
        return this.rawContent;
    }

    @Override
    public byte[] getBytes() {
        return this.baos.toByteArray();
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

