/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview.items;

import com.xtm.aem.services.translation.preview.items.BasePreviewItem;
import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CssPreviewItem
extends BasePreviewItem {
    private static final Pattern cssRefPattern = Pattern.compile("url\\((.*?)(#.*?)?\\)");
    private static final String WRAPPING_APOSTROPHE = "^'|'$";
    private static final String WRAPPING_QUOTE = "^\"|\"$";
    private static final String INLINE_DATA_MEDIA_PREFIX = "data:";
    private static final String NO_PROTOCOL_RELATIVE_URLS_PREFIX = "//";

    public CssPreviewItem(String path, ByteArrayOutputStream baos, String characterEncoding) {
        super(path, baos, characterEncoding);
    }

    @Override
    public Collection<String> getReferences() {
        HashSet<String> matches = new HashSet<String>();
        Matcher matcher = cssRefPattern.matcher(this.rawContent);
        while (matcher.find()) {
            String folderPath = StringUtils.substringBeforeLast((String)this.getPath(), (String)"/");
            String itemPath = this.processReference(matcher.group(1));
            if (!this.canAddReference(itemPath)) continue;
            if (itemPath.startsWith("/")) {
                matches.add(itemPath);
                continue;
            }
            matches.add(folderPath + "/" + itemPath);
        }
        return matches;
    }

    private String processReference(String itemPath) {
        return itemPath.trim().replaceAll(WRAPPING_APOSTROPHE, "").replaceAll(WRAPPING_QUOTE, "");
    }

    private boolean canAddReference(String itemPath) {
        return !StringUtils.startsWith((CharSequence)itemPath, (CharSequence)INLINE_DATA_MEDIA_PREFIX) && !StringUtils.startsWith((CharSequence)itemPath, (CharSequence)NO_PROTOCOL_RELATIVE_URLS_PREFIX);
    }
}

