/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.services.logging;

import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class XtmLoggingInterceptor {
    private static final Logger log = LoggerFactory.getLogger(XtmLoggingInterceptor.class);
    private static final String PASSWORD_REPLACEMENT = "<password>**** REDACTED ****</password>";
    private static final String BINARY_DATA_REPLACEMENT = "**** Binary data removed from log message ****";
    private static final String BINARY_CONTENT_TYPE_HEADER = "Content-Type: application/octet-stream";
    private static final String DUPLICATED_WORD = "Service";
    private static final int BINARY_CONTENT_TYPE_HEADER_LENGTH = "Content-Type: application/octet-stream".length();
    private static final Pattern BLANK_LINE_PATTERN = Pattern.compile("^$", 8);
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("(<password>.*?</password>)");

    private XtmLoggingInterceptor() {
        throw new UnsupportedOperationException("Non-instantiable");
    }

    static void log(java.util.logging.Logger javaUtilLogger, String message, PrintWriter writer) {
        message = XtmLoggingInterceptor.transform(message);
        if (writer != null) {
            writer.println(message);
            writer.flush();
        } else {
            log.info("{}\t{}", (Object)XtmLoggingInterceptor.getServiceName(javaUtilLogger), (Object)message);
        }
    }

    static String transform(String originalLogString) {
        String transformed = XtmLoggingInterceptor.replacePassword(originalLogString);
        transformed = XtmLoggingInterceptor.removeBinaryData(transformed);
        return transformed;
    }

    private static String replacePassword(String message) {
        return PASSWORD_PATTERN.matcher(message).replaceAll(PASSWORD_REPLACEMENT);
    }

    private static String removeBinaryData(String message) {
        String afterHeader;
        Matcher blankLineMatcher;
        int binaryDataHeader = message.indexOf(BINARY_CONTENT_TYPE_HEADER);
        if (binaryDataHeader > 0 && (blankLineMatcher = BLANK_LINE_PATTERN.matcher(afterHeader = StringUtils.substringAfter((String)message, (String)BINARY_CONTENT_TYPE_HEADER))).find()) {
            int start = blankLineMatcher.start();
            if (start == 0 && blankLineMatcher.find()) {
                start = blankLineMatcher.start();
            }
            if (start > 0) {
                message = message.substring(0, binaryDataHeader + BINARY_CONTENT_TYPE_HEADER_LENGTH + start) + "\n" + BINARY_DATA_REPLACEMENT;
            }
        }
        return message;
    }

    private static String getServiceName(java.util.logging.Logger javaUtilLogger) {
        return javaUtilLogger.getName().split("\\.")[4].replace("ServiceService", DUPLICATED_WORD);
    }
}

