/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl;

import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestActionFactory;
import com.xtm.aem.api.services.translation.XtmCanceller;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.rest.openapi.model.RSProjectWorkflowStartResponse;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectStatusUpdater {
    private static final Logger log = LoggerFactory.getLogger(ProjectStatusUpdater.class);
    private final TranslationCloudConfig cloudConfiguration;
    private final RestActionFactory restActionFactory;
    private final XtmCanceller canceller;

    public ProjectStatusUpdater(TranslationCloudConfig cloudConfiguration, RestActionFactory restActionFactory, XtmCanceller canceller) {
        this.cloudConfiguration = cloudConfiguration;
        this.restActionFactory = restActionFactory;
        this.canceller = canceller;
    }

    public TranslationConstants.TranslationStatus updateProjectStatus(TranslationConstants.TranslationStatus translationStatus, AemTranslationJob aemTranslationJob) throws TranslationException {
        switch (translationStatus) {
            case COMMITTED_FOR_TRANSLATION: {
                return this.startProject(aemTranslationJob);
            }
            case CANCEL: {
                return this.cancelProject(aemTranslationJob);
            }
            case SCOPE_REQUESTED: {
                return this.changeStatus(aemTranslationJob, TranslationConstants.TranslationStatus.SCOPE_COMPLETED);
            }
            case SUBMITTED: {
                return translationStatus;
            }
        }
        return this.getCurrentStatus(aemTranslationJob);
    }

    private TranslationConstants.TranslationStatus startProject(AemTranslationJob aemTranslationJob) throws TranslationException {
        List<Long> jobIds = aemTranslationJob.getAemTranslationObjects().stream().map(AemTranslationObject::getXtmJobId).collect(Collectors.toList());
        log.info("Starting project with internal id '{}' in XTM with id '{}' for XTM job IDs {}", new Object[]{aemTranslationJob.getAemJobId(), aemTranslationJob.getXtmProjectId(), jobIds});
        RSProjectWorkflowStartResponse result = this.restActionFactory.getStartProjectAction(aemTranslationJob.getXtmProjectId(), jobIds, this.cloudConfiguration).run();
        return Boolean.TRUE.equals(result.getStatus()) ? TranslationConstants.TranslationStatus.COMMITTED_FOR_TRANSLATION : TranslationConstants.TranslationStatus.UNKNOWN_STATE;
    }

    private TranslationConstants.TranslationStatus cancelProject(AemTranslationJob aemTranslationJob) throws TranslationException {
        this.canceller.cancel(aemTranslationJob);
        return TranslationConstants.TranslationStatus.CANCEL;
    }

    private TranslationConstants.TranslationStatus changeStatus(AemTranslationJob aemTranslationJob, TranslationConstants.TranslationStatus status) {
        log.info("Changing project status project with internal id '{}' in XTM with id '{}' to '{}'", new Object[]{aemTranslationJob.getAemJobId(), aemTranslationJob.getXtmProjectId(), status});
        return status;
    }

    private TranslationConstants.TranslationStatus getCurrentStatus(AemTranslationJob aemTranslationJob) throws TranslationException {
        log.info("Obtaining project status project with internal id {} in XTM with id {}", (Object)aemTranslationJob.getAemJobId(), (Object)aemTranslationJob.getXtmProjectId());
        TranslationConstants.TranslationStatus currentStatus = this.restActionFactory.getObtainProjectTranslationStatusAction(aemTranslationJob.getXtmProjectId(), this.cloudConfiguration).run();
        log.info("Changing project status project with internal id {} in XTM with id {} with status {}", new Object[]{aemTranslationJob.getAemJobId(), aemTranslationJob.getXtmProjectId(), currentStatus});
        return currentStatus;
    }
}

