/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl;

import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestActionFactory;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.api.xtm.AemTranslationProject;
import com.xtm.aem.rest.openapi.model.CUSTOMERLANGUAGEDEFINITIONS;
import com.xtm.aem.rest.openapi.model.RSJobStatusResponse;
import com.xtm.aem.rest.openapi.model.RSProjectStatusResponse;
import com.xtm.aem.soap.legacy.RetrieveTranslationResultAsInputStreamSoapAction;
import com.xtm.aem.soap.wsdl.LanguageCODE;
import com.xtm.aem.soap.wsdl.XtmPROJECTFILESMATCH;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={TranslationController.class}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class TranslationController {
    private static final Logger log = LoggerFactory.getLogger(TranslationController.class);
    @Reference
    private RestActionFactory restActionFactory;

    public InputStream retrieveTranslationResult(Long xtmProjectId, AemTranslationObject ato) throws TranslationException, PersistenceException {
        RetrieveTranslationResultAsInputStreamSoapAction action = new RetrieveTranslationResultAsInputStreamSoapAction(ato.getXtmJobId(), ato.getFileName(), ato.getProject().getConfig(), TranslationController.getTargetLanguageCode(ato.getJob()).value());
        InputStream translationResult = (InputStream)action.runWithHandlers();
        ato.setTranslationResult(translationResult);
        return ato.getTranslationResult();
    }

    public TranslationConstants.TranslationStatus obtainTranslationStatus(AemTranslationObject ato) throws TranslationException {
        Map<Long, TranslationConstants.TranslationStatus> xtmStatuses = this.restActionFactory.getObtainJobTranslationStatusAction(ato.getJob().getXtmProjectId(), Sets.newHashSet((Object[])new Long[]{ato.getXtmJobId()}), ato.getProject().getConfig()).run();
        ato.setTranslationStatus(xtmStatuses.get(ato.getXtmJobId()));
        return ato.getTranslationStatus();
    }

    public static XtmPROJECTFILESMATCH getFileMatching(AemTranslationObject ato, Collection<String> availableFiles) {
        if (ato.getFileName().contains("[" + Integer.toString(ato.getJob().getTargetLanguage().hashCode(), 36) + "]")) {
            return XtmPROJECTFILESMATCH.NO_MATCH;
        }
        if (availableFiles.contains(ato.getFileName())) {
            return XtmPROJECTFILESMATCH.MATCH_NAMES;
        }
        return XtmPROJECTFILESMATCH.NO_MATCH;
    }

    @Deprecated
    public static LanguageCODE getTargetLanguageCode(AemTranslationJob job) {
        return LanguageCODE.fromValue(TranslationController.getXtmLanguage(job));
    }

    public static CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum getTargetLanguageCodeEnum(AemTranslationJob job) {
        return CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum.fromValue(TranslationController.getXtmLanguage(job));
    }

    private static String getXtmLanguage(AemTranslationJob job) {
        String targetLanguage;
        Map<String, String> languageMapping = job.getProject().getConfig().getLanguageMapping();
        String xtmLanguage = languageMapping.get(targetLanguage = job.getTargetLanguage());
        if (xtmLanguage == null) {
            log.error("Failed to obtain XTM language for AEM language  '{}' from language mapping.", (Object)targetLanguage);
        }
        return xtmLanguage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getActiveXtmProjectId(AemTranslationJob atj) throws TranslationException {
        AemTranslationProject atp = atj.getProject();
        CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum targetLanguage = TranslationController.getTargetLanguageCodeEnum(atj);
        Class<TranslationController> clazz = TranslationController.class;
        synchronized (TranslationController.class) {
            ArrayList<Long> activeWithoutTargetLang = new ArrayList<Long>();
            for (Long xtmProjectId : atp.getXtmProjectIds()) {
                if (ArrayUtils.contains((Object[])atp.getFinishedXtmProjectIds(), (Object)xtmProjectId)) continue;
                RSProjectStatusResponse response = this.restActionFactory.getObtainProjectStatusAction(xtmProjectId, atp.getConfig()).run();
                boolean isArchived = RSProjectStatusResponse.ActivityEnum.ARCHIVED.equals((Object)response.getActivity()) || RSProjectStatusResponse.ActivityEnum.AUTO_ARCHIVED.equals((Object)response.getActivity());
                boolean isActive = RSProjectStatusResponse.ActivityEnum.ACTIVE.equals((Object)response.getActivity());
                boolean hasTargetLang = Objects.requireNonNull(response.getJobs()).stream().map(RSJobStatusResponse::getTargetLanguage).anyMatch(langCode -> targetLanguage.getValue().equals(langCode));
                if (isArchived) {
                    log.info("Project '{}' is archived. Attempting to re-activate", (Object)xtmProjectId);
                    isActive = this.restActionFactory.getProjectActivateAction(xtmProjectId, atp.getConfig()).run();
                }
                if (!isActive) continue;
                if (hasTargetLang) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return xtmProjectId;
                }
                activeWithoutTargetLang.add(xtmProjectId);
            }
            if (!activeWithoutTargetLang.isEmpty()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return (Long)activeWithoutTargetLang.get(0);
            }
            log.debug("Could not find active XTM Project ID");
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return null;
        }
    }

    public void ensureLanguageSet(AemTranslationProject atp, String language, Long xtmProjectId) throws TranslationException {
        if (atp.getTranslationJobs().stream().filter(atj -> xtmProjectId.equals(atj.getXtmProjectId())).filter(AemTranslationJob::isSentToXtm).map(AemTranslationJob::getTargetLanguage).noneMatch(language::equalsIgnoreCase)) {
            TranslationCloudConfig cloudConfig = atp.getConfig();
            ImmutableList targetLanguages = ImmutableList.of((Object)cloudConfig.getLanguageMapping().get(language));
            this.restActionFactory.getUpdateProjectTargetLanguageAction(xtmProjectId, (List<String>)targetLanguages, cloudConfig).run();
        }
    }

    public static XMLGregorianCalendar getXmlDueDate(Date dueDate) {
        if (dueDate != null) {
            try {
                GregorianCalendar c = new GregorianCalendar();
                c.setTime(dueDate);
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException("Could not transform date '" + dueDate + "'");
            }
        }
        return null;
    }
}

