/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl.servlets;

import com.adobe.granite.crypto.CryptoSupport;
import com.adobe.granite.translation.api.TranslationException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.config.http.ProxyConfigurationProvider;
import com.xtm.aem.api.rest.RestTokenManager;
import com.xtm.aem.models.config.TranslationCloudConfigPojo;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDropdownListServlet<T>
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(AbstractDropdownListServlet.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    AbstractDropdownListServlet() {
    }

    protected void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        TranslationCloudConfig cloudConfiguration = this.getCloudConfiguration(request);
        if (!this.getRestTokenManager().obtainToken(cloudConfiguration)) {
            String msg = "Failed to establish connection to XTM - please check provided credentials.";
            log.warn(msg);
            response.setStatus(401);
            response.getWriter().write(msg);
            return;
        }
        try {
            List<T> responseList = this.getData(request, cloudConfiguration);
            List dropdownValues = responseList.stream().sorted(this::comparator).map(this::toDropdownListEntry).collect(Collectors.toList());
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.setStatus(200);
            response.getWriter().write(MAPPER.writeValueAsString(dropdownValues));
        }
        catch (TranslationException e) {
            log.error("Failed to obtain customer list", (Throwable)e);
            response.setStatus(400);
            response.getWriter().write("Failed to obtain customer list from XTM API - please verify credentials");
        }
    }

    protected TranslationCloudConfig getCloudConfiguration(@NotNull SlingHttpServletRequest request) {
        String webserviceUri = request.getParameter("xtmWebserviceURI");
        String clientName = request.getParameter("xtmClientname");
        String password = request.getParameter("xtmPassword");
        Long userId = Optional.ofNullable(request.getParameter("xtmUserId")).map(Long::parseLong).orElse(null);
        return new TranslationCloudConfigPojo(webserviceUri, clientName, userId, password, this.getCryptoSupport(), this.getProxyConfigurationProvider());
    }

    protected abstract List<T> getData(SlingHttpServletRequest var1, TranslationCloudConfig var2) throws TranslationException;

    protected abstract Map<String, Object> toDropdownListEntry(T var1);

    protected abstract RestTokenManager getRestTokenManager();

    protected abstract CryptoSupport getCryptoSupport();

    protected abstract ProxyConfigurationProvider getProxyConfigurationProvider();

    protected abstract int comparator(@Nonnull T var1, @Nonnull T var2);

    protected String toLower(@Nullable String value) {
        return Optional.ofNullable(value).map(String::toLowerCase).orElse("");
    }
}

