/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.models;

import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationObject;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.google.common.collect.ImmutableMap;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.PreviewGenerationStrategy;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.config.XtmJobFileNamingStrategy;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ComplexAemTranslationObjectCreator.class}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class ComplexAemTranslationObjectCreator {
    private static final Logger log = LoggerFactory.getLogger(ComplexAemTranslationObjectCreator.class);
    public static final String NN_TRANSLATION_OBJECT = "translationObject";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    public AemTranslationObject create(Resource translationJobResource, TranslationObject translationObject, TranslationCloudConfig xtmCloudConfig) throws PersistenceException, TranslationException {
        InputStream preview;
        String aemJobId = (String)translationJobResource.getValueMap().get("aemJobId", String.class);
        String atoId = "I18NCOMPONENTSTRINGDICT".equals(translationObject.getTitle()) ? "I18NCOMPONENTSTRINGDICT_" + StringUtils.substringAfterLast((String)aemJobId, (String)"_") : translationObject.getTitle() + "_" + UUID.randomUUID();
        AemTranslationJob atj = (AemTranslationJob)translationJobResource.adaptTo(AemTranslationJob.class);
        ResourceResolver resourceResolver = translationJobResource.getResourceResolver();
        Resource objectsRoot = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)(translationJobResource.getPath() + "/objects"), Collections.emptyMap(), null, (boolean)false);
        String atoResourceName = ResourceUtil.createUniqueChildName((Resource)objectsRoot, (String)NN_TRANSLATION_OBJECT);
        Resource atoResource = resourceResolver.create(objectsRoot, atoResourceName, Collections.emptyMap());
        ModifiableValueMap atoMvm = Objects.requireNonNull((ModifiableValueMap)atoResource.adaptTo(ModifiableValueMap.class));
        atoMvm.put((Object)"fileName", (Object)this.getFileName(translationObject, xtmCloudConfig, translationJobResource.getResourceResolver(), atj.getTargetLanguage()));
        atoMvm.put((Object)"aemTranslationObjectId", (Object)atoId);
        this.addFile(atoResource, "file.xml", translationObject.getTranslationObjectXMLInputStream());
        if (PreviewGenerationStrategy.AEM.equals((Object)xtmCloudConfig.getPreviewGenerationStrategy()) && (preview = this.generatePreview(translationObject)) != null) {
            this.addFile(atoResource, "preview.zip", preview);
        }
        return (AemTranslationObject)atoResource.adaptTo(AemTranslationObject.class);
    }

    private void addFile(Resource parent, String name, InputStream data) throws PersistenceException {
        ResourceResolver resourceResolver = parent.getResourceResolver();
        Resource fileResource = resourceResolver.create(parent, name, (Map)ImmutableMap.of((Object)"jcr:primaryType", (Object)"nt:file"));
        resourceResolver.create(fileResource, "jcr:content", (Map)ImmutableMap.of((Object)"jcr:primaryType", (Object)"nt:unstructured", (Object)"jcr:data", (Object)data));
    }

    private String getFileName(TranslationObject translationObject, TranslationCloudConfig xtmCloudConfig, ResourceResolver resourceResolver, String targetLanguage) {
        String targetLanguageHashToken = Integer.toString(targetLanguage.hashCode(), 36);
        String timestampHashToken = Integer.toString(Timestamp.from(Instant.now()).hashCode(), 36);
        String title = translationObject.getTitle();
        if ("ASSETMETADATA".equals(title) || "TAGMETADATA".equals(title)) {
            return title + " [" + targetLanguageHashToken + timestampHashToken + "].xml";
        }
        if ((targetLanguage + ".json").equals(title) || "I18NCOMPONENTSTRINGDICT".equals(title)) {
            return "I18N [" + targetLanguageHashToken + timestampHashToken + "].xml";
        }
        XtmJobFileNamingStrategy namingStrategy = xtmCloudConfig.getXtmJobFileNamingStrategy();
        String sourcePath = this.getSourcePath(translationObject, xtmCloudConfig, resourceResolver);
        switch (namingStrategy) {
            case PATH_BASED: {
                return sourcePath + ".xml";
            }
            case TITLE_BASED: {
                return this.getTitleBasedJobName(translationObject, targetLanguage, title, sourcePath);
            }
        }
        throw new IllegalStateException("Unexpected strategy: '" + (Object)((Object)namingStrategy) + "'");
    }

    @NotNull
    private String getTitleBasedJobName(TranslationObject translationObject, String targetLanguage, String title, String sourcePath) {
        String extension;
        String baseName;
        int pathHash = sourcePath.hashCode() + targetLanguage.hashCode();
        String hashToken = Integer.toString(pathHash, 36);
        if ("text/html".equals(translationObject.getMimeType())) {
            baseName = title;
            extension = ".xml";
        } else {
            String filename = StringUtils.substringAfterLast((String)translationObject.getTranslationObjectSourcePath(), (String)"/");
            if (StringUtils.contains((CharSequence)filename, (CharSequence)".")) {
                baseName = StringUtils.substringBeforeLast((String)filename, (String)".");
                extension = "." + StringUtils.substringAfterLast((String)filename, (String)".");
            } else {
                baseName = filename;
                extension = "";
            }
        }
        return baseName + " [" + hashToken + "]" + extension;
    }

    private InputStream generatePreview(TranslationObject translationObject) {
        this.setResourceResolverFactory(translationObject);
        ZipInputStream zis = translationObject.getTranslationObjectPreview();
        if (zis != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ZipOutputStream zos = new ZipOutputStream((OutputStream)baos);){
                ZipEntry entry;
                while (null != (entry = zis.getNextEntry())) {
                    zos.putNextEntry(entry);
                    IOUtils.copy((InputStream)zis, (OutputStream)zos);
                }
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            return baos.toInputStream();
        }
        return null;
    }

    private void setResourceResolverFactory(TranslationObject translationObject) {
        try {
            Class<?> cls = translationObject.getClass();
            Method setMethod = cls.getMethod("setResolverFactory", ResourceResolverFactory.class);
            setMethod.invoke((Object)translationObject, this.resourceResolverFactory);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Could not set instance of resource resolver factory into translation object '{}'", (Object)translationObject.getId(), (Object)e);
        }
    }

    private String getSourcePath(TranslationObject translationObject, TranslationCloudConfig xtmCloudConfig, ResourceResolver resourceResolver) {
        String rawPageSourcePath = translationObject.getTranslationObjectSourcePath();
        switch (xtmCloudConfig.getLaunchHandlingStrategy()) {
            case SEPARATE: {
                return rawPageSourcePath;
            }
            case AGGREGATE: {
                return StringUtils.startsWith((CharSequence)rawPageSourcePath, (CharSequence)"/content/launches/") ? this.getSourcePathFromLaunch(rawPageSourcePath, resourceResolver) : rawPageSourcePath;
            }
        }
        return "";
    }

    private String getSourcePathFromLaunch(String launchPath, ResourceResolver resourceResolver) {
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        return this.getLaunchRoot(pageManager.getPage(launchPath)).map(Page::getPath).map(rootPath -> StringUtils.substringAfter((String)launchPath, (String)rootPath)).orElse(launchPath);
    }

    private Optional<Page> getLaunchRoot(Page launchPage) {
        if (launchPage == null) {
            return Optional.empty();
        }
        Page currentPage = launchPage;
        while (currentPage.getParent() != null) {
            currentPage = currentPage.getParent();
        }
        return currentPage.getContentResource().isResourceType("wcm/launches/components/launch") ? Optional.of(currentPage) : Optional.empty();
    }
}

