/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.cxf.common.util.CglibProxyHelper;
import org.apache.cxf.common.util.ProxyClassLoader;

public class ProxyHelper {
    static final ProxyHelper HELPER;

    protected ProxyHelper() {
    }

    protected Object getProxyInternal(ClassLoader loader, Class<?>[] interfaces, InvocationHandler handler) {
        ClassLoader combinedLoader = this.getClassLoaderForInterfaces(loader, interfaces);
        return Proxy.newProxyInstance(combinedLoader, interfaces, handler);
    }

    private ClassLoader getClassLoaderForInterfaces(ClassLoader loader, Class<?>[] interfaces) {
        if (this.canSeeAllInterfaces(loader, interfaces)) {
            return loader;
        }
        ProxyClassLoader combined = new ProxyClassLoader(loader, interfaces);
        for (Class<?> currentInterface : interfaces) {
            combined.addLoader(currentInterface.getClassLoader());
        }
        return combined;
    }

    private boolean canSeeAllInterfaces(ClassLoader loader, Class<?>[] interfaces) {
        for (Class<?> currentInterface : interfaces) {
            String ifName = currentInterface.getName();
            try {
                Class<?> ifClass = Class.forName(ifName, true, loader);
                if (ifClass != currentInterface) {
                    return false;
                }
                for (Method m : ifClass.getMethods()) {
                    Class<?> returnType = m.getReturnType();
                    if (!returnType.isPrimitive()) {
                        Class.forName(returnType.getName(), true, loader);
                    }
                    for (Class<?> p : m.getParameterTypes()) {
                        if (p.isPrimitive()) continue;
                        Class.forName(p.getName(), true, loader);
                    }
                }
            }
            catch (NoClassDefFoundError e) {
                return false;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return true;
    }

    public static Object getProxy(ClassLoader loader, Class<?>[] interfaces, InvocationHandler handler) {
        return HELPER.getProxyInternal(loader, interfaces, handler);
    }

    static {
        ProxyHelper theHelper = null;
        try {
            theHelper = new CglibProxyHelper();
        }
        catch (Throwable ex) {
            theHelper = new ProxyHelper();
        }
        HELPER = theHelper;
    }
}

