(function(window, document, Granite, $) {
  'use strict';

  var projectNameTemplateRegEx = /[\\\/:*?"<>|{}&]/i

  $(window).adaptTo('foundation-registry').register('foundation.validation.validator', {
    selector: "#projectNameTemplate",
    validate: function(el) {
      var fieldValue = el.value;

      if (fieldValue && projectNameTemplateRegEx.test(fieldValue)) {
        return Granite.I18n.get('Please enter a project name template without forbidden characters [\\\/:*?"<>|{}&]');
      }
    }
  });
})(window, document, Granite, Granite.$);