/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.models.raw;

import com.adobe.granite.translation.api.TranslationConstants;
import com.xtm.aem.api.raw.RawTranslationJob;
import com.xtm.aem.api.raw.RawTranslationPage;
import com.xtm.aem.api.raw.WorkflowOperationError;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={Resource.class}, adapters={RawTranslationJob.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class RawTranslationJobModel
implements RawTranslationJob {
    @Self
    private Resource translationGadgetResource;
    @ValueMapValue
    private Date dueDate;
    @ValueMapValue
    private String destinationLanguage;
    @ValueMapValue(name="translationObjectID")
    private String translationObjectId;
    @ValueMapValue(name="translationStatus")
    private String translationStatusRaw;
    @ValueMapValue(name="workflowOperationError")
    private String workflowOperationErrorRaw;
    private final List<RawTranslationPage> pages = new ArrayList<RawTranslationPage>();
    private TranslationConstants.TranslationStatus translationStatus;
    private WorkflowOperationError workflowOperationError;

    @PostConstruct
    protected void postConstruct() {
        Resource childPages = this.translationGadgetResource.getChild("child_pages");
        if (childPages != null) {
            Iterable buckets = childPages.getChildren();
            for (Resource bucket : buckets) {
                bucket.getChildren().forEach(resource -> {
                    RawTranslationPage rawTranslationPage = (RawTranslationPage)resource.adaptTo(RawTranslationPage.class);
                    if (rawTranslationPage != null) {
                        this.pages.add(rawTranslationPage);
                    }
                });
            }
        }
    }

    @Override
    public String getPath() {
        return this.translationGadgetResource.getPath();
    }

    @Override
    public RawTranslationPage getPage(String aemId) {
        return this.pages.stream().filter(page -> StringUtils.equals((CharSequence)page.getTranslationObjectId(), (CharSequence)aemId)).findFirst().orElse(null);
    }

    @Override
    public TranslationConstants.TranslationStatus getTranslationStatus() {
        if (this.translationStatus == null) {
            this.translationStatus = TranslationConstants.TranslationStatus.valueOf((String)this.translationStatusRaw);
        }
        return this.translationStatus;
    }

    @Override
    public WorkflowOperationError getWorkflowOperationError() {
        if (this.workflowOperationError == null && this.workflowOperationErrorRaw != null) {
            this.workflowOperationError = WorkflowOperationError.valueOf(this.workflowOperationErrorRaw);
        }
        return this.workflowOperationError;
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public String getDestinationLanguage() {
        return this.destinationLanguage;
    }

    @Override
    public String getTranslationObjectId() {
        return this.translationObjectId;
    }

    @Override
    public List<RawTranslationPage> getPages() {
        return this.pages;
    }
}

