/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.models.xtm;

import com.google.common.collect.ImmutableList;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.config.TranslationCloudConfigFinder;
import com.xtm.aem.api.raw.RawTranslationJob;
import com.xtm.aem.api.raw.RawTranslationProject;
import com.xtm.aem.api.shared.ResourceResolverProvider;
import com.xtm.aem.api.util.Predicates;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationProject;
import com.xtm.translation.connector.xtmforaem.core.impl.TranslationJobController;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, adapters={AemTranslationProject.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class AemTranslationProjectModel
implements AemTranslationProject {
    private static final Logger log = LoggerFactory.getLogger(AemTranslationProjectModel.class);
    @Self
    private Resource resource;
    @Self
    private ModifiableValueMap mvm;
    @OSGiService
    private TranslationCloudConfigFinder configFinder;
    @OSGiService
    private ResourceResolverProvider provider;
    @ValueMapValue
    private String aemProjectPath;
    @ValueMapValue
    private String[] aemTranslationJobIds;
    @ValueMapValue
    private Long[] xtmProjectIds;
    @ValueMapValue
    private Long[] finishedXtmProjectIds;
    @ValueMapValue
    private String aemConfigFolder;
    private Map<String, AemTranslationJob> aemTranslationJobs;
    private RawTranslationProject rawProject;
    private TranslationCloudConfig config;

    @PostConstruct
    protected void postConstruct() {
        this.aemTranslationJobs = Arrays.stream(this.aemTranslationJobIds).map(this::getTranslationJobInternal).collect(Collectors.toMap(AemTranslationJob::getAemJobId, Function.identity()));
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public AemTranslationJob getTranslationJob(String aemTranslationJobId) {
        if (!ArrayUtils.contains((Object[])this.aemTranslationJobIds, (Object)aemTranslationJobId)) {
            throw new IllegalArgumentException("Translation job '" + aemTranslationJobId + "' does not belong to project '" + this.aemProjectPath + "'");
        }
        return this.aemTranslationJobs.get(aemTranslationJobId);
    }

    @Override
    public Collection<AemTranslationJob> getTranslationJobs() {
        return ImmutableList.copyOf(this.aemTranslationJobs.values());
    }

    @Override
    public void setAemTranslationJobIds(String[] newIds) {
        this.aemTranslationJobIds = newIds;
        this.mvm.put((Object)"aemTranslationJobIds", (Object)newIds);
        this.aemTranslationJobs.keySet().retainAll(Arrays.asList(this.aemTranslationJobIds));
        Arrays.stream(newIds).filter(Predicates.not(this.aemTranslationJobs.keySet()::contains)).map(this::getTranslationJobInternal).filter(Objects::nonNull).forEach(atj -> this.aemTranslationJobs.put(atj.getAemJobId(), (AemTranslationJob)atj));
    }

    @Override
    public Long[] getXtmProjectIds() {
        return (Long[])ArrayUtils.clone((Object[])this.xtmProjectIds);
    }

    @Override
    public Long[] getFinishedXtmProjectIds() {
        return (Long[])ArrayUtils.clone((Object[])this.finishedXtmProjectIds);
    }

    @Override
    public void markXtmProjectAsFinished(Long xtmProjectId) {
        this.finishedXtmProjectIds = (Long[])ArrayUtils.add((Object[])this.finishedXtmProjectIds, (Object)xtmProjectId);
        this.mvm.put((Object)"finishedXtmProjectIds", (Object)this.finishedXtmProjectIds);
    }

    @Override
    public RawTranslationProject getRawProject() {
        Resource rawProjectResource;
        if (this.rawProject == null && (rawProjectResource = this.resource.getResourceResolver().getResource(this.aemProjectPath)) != null) {
            this.rawProject = (RawTranslationProject)rawProjectResource.adaptTo(RawTranslationProject.class);
        }
        return this.rawProject;
    }

    @Override
    public TranslationCloudConfig getConfig() {
        if (this.config == null) {
            try (ResourceResolver crr = this.provider.getTranslationConfigResourceResolver();){
                String configFolderPath = this.rawProject != null ? this.rawProject.getConfigFolder() : this.aemConfigFolder;
                this.config = this.configFinder.getConfig(configFolderPath, crr);
            }
            catch (LoginException e) {
                log.error("Failed to obtain Translation Config Resource Resolver", (Throwable)e);
            }
        }
        return this.config;
    }

    @Override
    public void setReference(RawTranslationProject rawProject) {
        if (rawProject == null) {
            return;
        }
        if (!StringUtils.equals((CharSequence)this.aemProjectPath, (CharSequence)rawProject.getPath())) {
            throw new IllegalArgumentException("Path of the passed project does not match the expected one. '" + this.aemProjectPath + "' != '" + rawProject.getPath() + "'");
        }
        this.rawProject = rawProject;
        this.updateJobIds(rawProject);
        this.updateXtmProjectIds();
    }

    @Override
    public void setReference(TranslationCloudConfig config) {
        if (config == null) {
            return;
        }
        if (!StringUtils.equals((CharSequence)this.aemConfigFolder, (CharSequence)config.getFolderPath())) {
            throw new IllegalArgumentException("Path of the passed project does not match the expected one");
        }
        this.config = config;
    }

    private AemTranslationJob getTranslationJobInternal(String aemTranslationJobId) {
        if (!ArrayUtils.contains((Object[])this.aemTranslationJobIds, (Object)aemTranslationJobId)) {
            throw new IllegalArgumentException("Translation job '" + aemTranslationJobId + "' does not belong to project '" + this.aemProjectPath + "'");
        }
        AemTranslationJob job = TranslationJobController.get(this.resource.getResourceResolver(), aemTranslationJobId);
        if (job != null) {
            job.setReference(this);
        }
        return job;
    }

    private void updateXtmProjectIds() {
        Object[] rawXtmProjectIds = (Long[])Arrays.stream(this.aemTranslationJobIds).map(id -> TranslationJobController.get(this.resource.getResourceResolver(), id)).filter(Objects::nonNull).map(AemTranslationJob::getXtmProjectId).filter(Objects::nonNull).distinct().sorted().toArray(Long[]::new);
        if (!Arrays.equals((Object[])this.xtmProjectIds, rawXtmProjectIds)) {
            this.xtmProjectIds = rawXtmProjectIds;
            this.mvm.put((Object)"xtmProjectIds", (Object)this.xtmProjectIds);
        }
    }

    private void updateJobIds(RawTranslationProject rawProject) {
        Object[] rawTranslationJobIds = (String[])rawProject.getTranslationJobs().stream().map(RawTranslationJob::getTranslationObjectId).filter(StringUtils::isNotEmpty).sorted().toArray(String[]::new);
        HashSet allJobIds = new HashSet();
        CollectionUtils.addAll(allJobIds, (Object[])rawTranslationJobIds);
        CollectionUtils.addAll(allJobIds, (Object[])this.aemTranslationJobIds);
        Object[] allJobIdsArray = allJobIds.toArray(new String[0]);
        if (!Arrays.equals(this.aemTranslationJobIds, allJobIdsArray)) {
            this.setAemTranslationJobIds((String[])allJobIdsArray);
        }
    }
}

