/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.XtmAction;
import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.OauthAccessTokenModel;
import com.xtm.aem.api.rest.RestClientFactory;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.api.rest.RestTokenManager;
import com.xtm.aem.api.rest.RestTokenStore;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseXtmRestAction<T>
implements XtmAction<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseXtmRestAction.class);
    static final String MSG_NETWORK_ERROR = "A network error occurred when connecting to XTM";
    static final String MSG_CONNECTOR_ERROR = "An error occurred while communicating with XTM";
    static final String MSG_UNSPECIFIED_ERROR = "Unspecified error when calling XTM";
    static final String MSG_REST_API_ERROR = "An error occurred while communicating with XTM REST API";
    static final String MSG_API_TOKEN_REFRESH_FAILED_ERROR = "Failed to refresh token. Please check the provided credentials for cloud configuration: {}";
    static final String MSG_API_TOKEN_REFRESH_ATTEMPT = "Unauthorized access. Attempting to refresh the access token for cloud configuration: {}";
    static final String MSG_TOKEN_NOT_FOUND = "Token for XTM config: '{}' has not been found";
    protected final TranslationCloudConfig cloudConfig;
    protected final RestClientFactory clientFactory;
    protected final RestTokenStore tokenStore;
    protected final RestTokenManager tokenManager;

    protected BaseXtmRestAction(TranslationCloudConfig cloudConfig, RestServicesWrapper restServicesWrapper) {
        this.cloudConfig = cloudConfig;
        this.clientFactory = restServicesWrapper.getClientFactory();
        this.tokenStore = restServicesWrapper.getTokenStore();
        this.tokenManager = restServicesWrapper.getRestTokenManager();
    }

    @Override
    public final T run() throws TranslationException {
        T result = null;
        this.obtainTokenIfNotPresent();
        try {
            result = this.runInternal();
        }
        catch (ConnectException | UnknownHostException e) {
            throw new TranslationException(MSG_NETWORK_ERROR, (Throwable)e, TranslationException.ErrorCode.ENGINE_TEMP_UNAVAILABLE);
        }
        catch (ApiException e) {
            return this.processApiException(e);
        }
        catch (XtmConnectorException e) {
            throw new TranslationException(MSG_CONNECTOR_ERROR, (Throwable)e, TranslationException.ErrorCode.REQUEST_FAILED);
        }
        catch (Exception e) {
            throw new TranslationException(MSG_UNSPECIFIED_ERROR, (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
        return result;
    }

    private void obtainTokenIfNotPresent() throws TranslationException {
        OauthAccessTokenModel tokenResponse = this.tokenStore.getTokenResponse(this.cloudConfig);
        if (tokenResponse == null) {
            log.debug(MSG_TOKEN_NOT_FOUND, (Object)this.cloudConfig.getPath());
            if (!this.tokenManager.obtainOrRefreshToken(this.cloudConfig)) {
                log.error(MSG_API_TOKEN_REFRESH_FAILED_ERROR, (Object)this.cloudConfig.getPath());
                throw new TranslationException(MSG_API_TOKEN_REFRESH_FAILED_ERROR, TranslationException.ErrorCode.REQUEST_FAILED);
            }
        }
    }

    private T processApiException(ApiException e) throws TranslationException {
        OauthAccessTokenModel tokenResponse = this.tokenStore.getTokenResponse(this.cloudConfig);
        if (e.getCode() == 401 && tokenResponse != null && tokenResponse.isExpired()) {
            log.warn(MSG_API_TOKEN_REFRESH_ATTEMPT, (Object)this.cloudConfig.getPath());
            this.tokenStore.clearToken(this.cloudConfig);
            if (this.tokenManager.obtainOrRefreshToken(this.cloudConfig)) {
                return this.run();
            }
            log.error(MSG_API_TOKEN_REFRESH_FAILED_ERROR, (Object)this.cloudConfig.getPath());
            throw new TranslationException(MSG_REST_API_ERROR, (Throwable)e, TranslationException.ErrorCode.REQUEST_FAILED);
        }
        throw new TranslationException(MSG_REST_API_ERROR, (Throwable)e, TranslationException.ErrorCode.REQUEST_FAILED);
    }

    protected abstract T runInternal() throws Exception;

    protected String getAccessToken() {
        return this.tokenStore.getAccessToken(this.cloudConfig);
    }

    protected ApiClient getApiClient() throws ApiException {
        return this.clientFactory.create(this.cloudConfig);
    }
}

