/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.rest.actions.BaseXtmRestAction;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.api.ProjectActivityApi;
import com.xtm.aem.rest.openapi.api.ProjectsApi;
import com.xtm.aem.rest.openapi.model.RSArchiveProjectResponse;
import com.xtm.aem.rest.openapi.model.RSProjectDeletionResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelProjectRestAction
extends BaseXtmRestAction<Map<Long, Boolean>> {
    private static final Logger log = LoggerFactory.getLogger(CancelProjectRestAction.class);
    private final Collection<Long> projectIds;

    public CancelProjectRestAction(Collection<Long> projectIds, TranslationCloudConfig cloudConfig, RestServicesWrapper restServicesWrapper) {
        super(cloudConfig, restServicesWrapper);
        this.projectIds = projectIds;
    }

    @Override
    protected Map<Long, Boolean> runInternal() throws Exception {
        log.trace("CancelProjectRestAction.runInternal");
        log.info("Canceling projects with IDs '{}'...", this.projectIds);
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>();
        block4: for (Long projectId : this.projectIds) {
            switch (this.cloudConfig.getProjectCancellationStrategy()) {
                case DELETE_KEEP_TM: {
                    result.put(projectId, this.deleteProject(projectId, true));
                    continue block4;
                }
                case DELETE_WITH_TM: {
                    result.put(projectId, this.deleteProject(projectId, false));
                    continue block4;
                }
            }
            result.put(projectId, this.archiveProject(projectId));
        }
        return result;
    }

    private Boolean archiveProject(Long projectId) throws ApiException {
        log.info("Archiving project {}", (Object)projectId);
        ProjectActivityApi api = new ProjectActivityApi(this.getApiClient());
        RSArchiveProjectResponse response = api.archiveProjectUsingPOST(this.getAccessToken(), projectId);
        return response.getSuccess();
    }

    private Boolean deleteProject(Long projectId, boolean keepTm) throws ApiException {
        ProjectsApi api = new ProjectsApi(this.getApiClient());
        String option = keepTm ? "DELETE_LEAVING_TM" : "DELETE_WITH_TM";
        log.info("Deleting project {} - {}", (Object)projectId, (Object)option);
        RSProjectDeletionResponse response = api.deleteProjectUsingDELETE(this.getAccessToken(), projectId, option);
        return response.getSuccess();
    }
}

